package com.pica.cloud.permission.permission.server.service.impl;

import com.pica.cloud.permission.permission.server.constants.Constants;
import com.pica.cloud.permission.permission.server.entity.Role;
import com.pica.cloud.permission.permission.server.mapper.RoleMapper;
import com.pica.cloud.permission.permission.server.service.RoleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import java.util.Date;
import java.util.List;

/**
 * @author andong
 * @create 2019/9/2
 */
@Service
public class RoleServiceImpl implements RoleService {

    @Autowired
    private RoleMapper roleMapper;

    @Override
    @Transactional
    public void addRole(Role role) {
        role.setModifiedId(role.getCreatedId());
        role.setCreatedTime(new Date());
        role.setModifiedTime(role.getCreatedTime());
        roleMapper.insertSelective(role);
    }

    @Override
    public Role getById(int id) {
        return roleMapper.selectByPrimaryKey(id);
    }

    @Override
    public Role getByCode(String code) {
        return roleMapper.getByCode(code);
    }

    @Override
    public List<Role> getByProductType(int productType) {
        return roleMapper.getByProductType(productType);
    }

    @Override
    @Transactional
    public void updateRole(Role role) {
        role.setModifiedTime(new Date());
        roleMapper.updateByPrimaryKeySelective(role);
    }

    @Override
    @Transactional
    public void deleteRole(int id, int modifiedId) {
        Role role = new Role();
        role.setId(id);
        role.setDeleteFlag(Constants.DELETE_FLAG_INVALID);
        role.setModifiedId(modifiedId);
        role.setModifiedTime(new Date());
    }
}
