package com.pica.cloud.permission.permission.server.service;

import com.pica.cloud.permission.permission.server.entity.DataPrivilege;
import com.pica.cloud.permission.permission.server.entity.Resource;
import com.pica.cloud.permission.permission.server.entity.RoleResource;
import com.pica.cloud.permission.permission.server.entity.UserRole;

/**
 * @author andong
 * @create 2019/9/5
 */
public interface PermissionCacheService {

    //添加角色-资源
    void addRoleResource(RoleResource roleResource);

    //删除角色-资源
    void deleteRoleResource(RoleResource roleResource);

    //删除角色下所有资源
    void deleteAllRoleResource(int roleId);

    //添加用户-角色
    void addUserRole(UserRole userRole);

    //删除用户-角色
    void deleteUserRole(UserRole userRole);

    //修改资源
    void updateResource(Resource oldRes, Resource newRes);

    //修改数据资源
    void updateDataPrivilege(DataPrivilege oldDataPrivilege, DataPrivilege newDataPrivilege);

    //初始化角色-资源（云鹊医产品系）
    void initAllRoleResource();

    //初始化用户-角色（云鹊医用户）
    void initUserRole(int userId);
}
