package com.pica.cloud.permission.permission.server.validation;

import com.pica.cloud.foundation.entity.PicaException;
import com.pica.cloud.foundation.entity.PicaResultCode;
import com.pica.cloud.permission.permission.server.entity.DataPrivilege;
import org.apache.commons.lang.StringUtils;

/**
 * @author andong
 * @create 2019/9/2
 */
public class DataPrivilegeValidation {

    public static void addDataPrivilegeValidate(DataPrivilege dataPrivilege) {
        if (dataPrivilege.getResourceId() == null) {
            throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "资源ID为空");
        }
        if (StringUtils.isBlank(dataPrivilege.getDescription())) {
            throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "数据权限描述为空");
        }
        if (StringUtils.isBlank(dataPrivilege.getConfig())) {
            throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "数据权限配置为空");
        }
        if (dataPrivilege.getCreatedId() == null) {
            throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "操作人ID为空");
        }
    }

    public static void updateDataPrivilegeValidate(DataPrivilege dataPrivilege) {
        if (dataPrivilege.getId() == null) {
            throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "数据权限ID为空");
        }
        if (dataPrivilege.getDescription() != null && StringUtils.isBlank(dataPrivilege.getDescription())) {
            throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "数据权限描述为空");
        }
        if (dataPrivilege.getConfig() != null && StringUtils.isBlank(dataPrivilege.getConfig())) {
            throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "数据权限配置为空");
        }
        if (dataPrivilege.getModifiedId() == null) {
            throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "操作人ID为空");
        }
        if (dataPrivilege.getConfig() == null && dataPrivilege.getDescription() == null && dataPrivilege.getConfigExt() == null) {
            throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "缺少必要参数");
        }
    }

}
