package com.pica.cloud.permission.permission.server.mapper;

import com.pica.cloud.permission.permission.common.dto.RoleResourceDto;
import com.pica.cloud.permission.permission.server.entity.RoleResource;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import java.util.List;

@Mapper
public interface RoleResourceMapper {

    RoleResource selectByPrimaryKey(int id);

    int insertSelective(RoleResource roleResource);

    List<RoleResourceDto> getByRoleId(int roleId);

    int updateByPrimaryKeySelective(RoleResource roleResource);

    int deleteAll(@Param("roleId") int roleId, @Param("modifiedId") int modifiedId);

    Integer checkResourceUsed(int resourceId);

    Integer checkDataPrivilegeUsed(int dataPrivilegeId);

    Integer checkExist(RoleResource roleResource);

    Integer checkRoleResourceExist(RoleResource roleResource);

    List<RoleResourceDto> getByResourceId(int resourceId);

    List<RoleResourceDto> getList(@Param("productType") int productType, @Param("type") int type);

}