package com.pica.cloud.permission.permission.server.service.impl;

import com.pica.cloud.foundation.redis.ICacheClient;
import com.pica.cloud.permission.permission.common.constants.ProductTypeEnum;
import com.pica.cloud.permission.permission.common.constants.ResourceTypeEnum;
import com.pica.cloud.permission.permission.common.dto.RoleResourceDto;
import com.pica.cloud.permission.permission.common.dto.UserRoleDto;
import com.pica.cloud.permission.permission.server.constants.Constants;
import com.pica.cloud.permission.permission.server.entity.*;
import com.pica.cloud.permission.permission.server.mapper.*;
import com.pica.cloud.permission.permission.server.service.PermissionCacheService;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.List;

/**
 * @author andong
 * @create 2019/9/5
 */
@Service
public class PermissionCacheServiceImpl implements PermissionCacheService {

    private Logger logger = LoggerFactory.getLogger(PermissionCacheServiceImpl.class);
    @Autowired
    private ICacheClient cacheClient;
    @Autowired
    private RoleMapper roleMapper;
    @Autowired
    private ResourceMapper resourceMapper;
    @Autowired
    private DataPrivilegeMapper dataPrivilegeMapper;
    @Autowired
    private RoleResourceMapper roleResourceMapper;
    @Autowired
    private UserRoleMapper userRoleMapper;

    //添加角色-资源
    public void addRoleResource(RoleResource roleResource) {
        Role role = roleMapper.selectByPrimaryKey(roleResource.getRoleId());
        //目前仅将云鹊医角色资源信息放入缓存
        if (role.getProductType().intValue() != ProductTypeEnum.DOCTOR.code()) {
            return;
        }
        Resource resource = resourceMapper.selectByPrimaryKey(roleResource.getResourceId());
        DataPrivilege dataPrivilege = roleResource.getDataPrivilegeId() == null ? null : dataPrivilegeMapper.selectByPrimaryKey(roleResource.getDataPrivilegeId());
        String url = resource.getUrl();
        String config = dataPrivilege == null ? StringUtils.EMPTY : dataPrivilege.getConfig();
        String configExt = dataPrivilege == null ? StringUtils.EMPTY : dataPrivilege.getConfigExt();
        String dataValue = url + Constants.DATA_SPLIT + config + Constants.DATA_SPLIT + configExt;
        try {
            cacheClient.sadd(Constants.KEY_ROLE_URL + role.getCode(), url);
            cacheClient.sadd(Constants.KEY_ROLE_DATA + role.getCode(), dataValue);
        } catch (Exception ex) {
            logger.error(ex.getMessage(), ex);
        }
    }

    //删除角色-资源
    public void deleteRoleResource(RoleResource roleResource) {
        Role role = roleMapper.selectByPrimaryKey(roleResource.getRoleId());
        //目前仅更新云鹊医角色资源信息
        if (role.getProductType().intValue() != ProductTypeEnum.DOCTOR.code()) {
            return;
        }
        Resource resource = resourceMapper.selectByPrimaryKey(roleResource.getResourceId());
        DataPrivilege dataPrivilege = roleResource.getDataPrivilegeId() == null ? null : dataPrivilegeMapper.selectByPrimaryKey(roleResource.getDataPrivilegeId());
        String url = resource.getUrl();
        String config = dataPrivilege == null ? StringUtils.EMPTY : dataPrivilege.getConfig();
        String configExt = dataPrivilege == null ? StringUtils.EMPTY : dataPrivilege.getConfigExt();
        String dataValue = url + Constants.DATA_SPLIT + config + Constants.DATA_SPLIT + configExt;
        try {
            cacheClient.srem(Constants.KEY_ROLE_DATA + role.getCode(), dataValue);
            Integer pk = roleResourceMapper.checkRoleResourceExist(roleResource);
            if (pk == null) {
                cacheClient.srem(Constants.KEY_ROLE_URL + role.getCode(), url);
            }
        } catch (Exception ex) {
            logger.error(ex.getMessage(), ex);
        }
    }

    //删除角色下所有资源
    public void deleteAllRoleResource(Role role) {
        //目前仅更新云鹊医角色资源信息
        if (role.getProductType().intValue() != ProductTypeEnum.DOCTOR.code()) {
            return;
        }
        try {
            cacheClient.del(Constants.KEY_ROLE_URL + role.getCode());
            cacheClient.del(Constants.KEY_ROLE_DATA + role.getCode());
        } catch (Exception ex) {
            logger.error(ex.getMessage(), ex);
        }
    }

    //添加用户-角色
    public void addUserRole(UserRole userRole) {
        //目前仅缓存云鹊医用户角色信息
        if (userRole.getProductType().intValue() != ProductTypeEnum.DOCTOR.code()) {
            return;
        }
        //Role role = roleMapper.selectByPrimaryKey(userRole.getRoleId());
        //cacheClient.sadd(Constants.KEY_DOCTOR_ROLE + userRole.getUserId(), role.getCode());
        this.initUserRole(userRole.getUserId());
    }

    //删除用户-角色
    public void deleteUserRole(UserRole userRole) {
        //目前仅缓存云鹊医用户角色信息
        if (userRole.getProductType().intValue() != ProductTypeEnum.DOCTOR.code()) {
            return;
        }
        //Role role = roleMapper.selectByPrimaryKey(userRole.getRoleId());
        //cacheClient.srem(Constants.KEY_DOCTOR_ROLE + userRole.getUserId(), role.getCode());
        this.initUserRole(userRole.getUserId());
    }

    //修改资源
    public void updateResource(Resource oldRes, Resource newRes) {
        //目前仅处理云鹊医API资源信息
        if (oldRes.getProductType().intValue() != ProductTypeEnum.DOCTOR.code()
                || oldRes.getType().intValue() != ResourceTypeEnum.API.code()) {
            return;
        }
        if (StringUtils.isBlank(newRes.getUrl())) {  //未修改url
            return;
        }
        List<RoleResourceDto> list = roleResourceMapper.getByResourceId(oldRes.getId());
        String oldUrl = oldRes.getUrl();
        String newUrl = newRes.getUrl();
        try {
            for (RoleResourceDto dto : list) {
                cacheClient.srem(Constants.KEY_ROLE_URL + dto.getRoleCode(), oldUrl);
                cacheClient.sadd(Constants.KEY_ROLE_URL + dto.getRoleCode(), newUrl);
                if (dto.getDataPrivilegeId().intValue() == 0) {
                    cacheClient.srem(Constants.KEY_ROLE_DATA + dto.getRoleCode(), oldUrl + Constants.DATA_SPLIT + Constants.DATA_SPLIT);
                    cacheClient.sadd(Constants.KEY_ROLE_DATA + dto.getRoleCode(), newUrl + Constants.DATA_SPLIT + Constants.DATA_SPLIT);
                } else {
                    DataPrivilege dataPrivilege = dataPrivilegeMapper.selectByPrimaryKey(dto.getDataPrivilegeId().intValue());
                    String config = dataPrivilege == null ? StringUtils.EMPTY : dataPrivilege.getConfig();
                    String configExt = dataPrivilege == null ? StringUtils.EMPTY : dataPrivilege.getConfigExt();
                    String oldDataValue = oldUrl + Constants.DATA_SPLIT + config + Constants.DATA_SPLIT + configExt;
                    String newDataValue = newUrl + Constants.DATA_SPLIT + config + Constants.DATA_SPLIT + configExt;
                    cacheClient.srem(Constants.KEY_ROLE_DATA + dto.getRoleCode(), oldDataValue);
                    cacheClient.sadd(Constants.KEY_ROLE_DATA + dto.getRoleCode(), newDataValue);
                }
            }
        } catch (Exception ex) {
            logger.error(ex.getMessage(), ex);
        }
    }

    //修改数据资源
    public void updateDataPrivilege(DataPrivilege oldDataPrivilege, DataPrivilege newDataPrivilege) {
        int dataPrivilegeId = oldDataPrivilege.getId().intValue();
        int resourceId = oldDataPrivilege.getResourceId().intValue();
        Resource resource = resourceMapper.selectByPrimaryKey(resourceId);
        //目前仅处理云鹊医API数据权限信息
        if (resource.getProductType().intValue() != ProductTypeEnum.DOCTOR.code()
                || resource.getType().intValue() != ResourceTypeEnum.API.code()) {
            return;
        }
        //未修改配置信息
        if (newDataPrivilege.getConfig() == null && newDataPrivilege.getConfigExt() == null) {
            return;
        }
        String url = resource.getUrl();
        String oldConfig = oldDataPrivilege.getConfig();
        String oldConfigExt = oldDataPrivilege.getConfigExt();
        String oldDataValue = url + Constants.DATA_SPLIT + oldConfig + Constants.DATA_SPLIT + oldConfigExt;
        String newConfig = newDataPrivilege.getConfig() == null ? oldConfig : newDataPrivilege.getConfig();
        String newConfigExt = newDataPrivilege.getConfigExt() == null ? oldConfigExt : newDataPrivilege.getConfigExt();
        String newDataValue = url + Constants.DATA_SPLIT + newConfig + Constants.DATA_SPLIT + newConfigExt;

        List<RoleResourceDto> list = roleResourceMapper.getByResourceId(resourceId);
        try {
            for (RoleResourceDto dto : list) {
                if (dto.getDataPrivilegeId().intValue() == dataPrivilegeId) {
                    cacheClient.srem(Constants.KEY_ROLE_DATA + dto.getRoleCode(), oldDataValue);
                    cacheClient.sadd(Constants.KEY_ROLE_DATA + dto.getRoleCode(), newDataValue);
                }
            }
        } catch (Exception ex) {
            logger.error(ex.getMessage(), ex);
        }
    }

    //初始化角色-资源（云鹊医产品系）
    public void initAllRoleResource() {
        List<RoleResourceDto> list = roleResourceMapper.getList(ProductTypeEnum.DOCTOR.code(), ResourceTypeEnum.API.code());
        try {
            for (RoleResourceDto dto : list) {
                String roleCode = dto.getRoleCode();
                String url = dto.getUrl();
                String config = dto.getConfig() == null ? StringUtils.EMPTY : dto.getConfig();
                String configExt = dto.getConfigExt() == null ? StringUtils.EMPTY : dto.getConfigExt();
                String dataValue = url + Constants.DATA_SPLIT + config + Constants.DATA_SPLIT + configExt;
                cacheClient.sadd(Constants.KEY_ROLE_URL + roleCode, url);
                cacheClient.sadd(Constants.KEY_ROLE_DATA + roleCode, dataValue);
            }
        } catch (Exception ex) {
            logger.error(ex.getMessage(), ex);
        }
    }

    //初始化用户-角色（云鹊医用户）
    public void initUserRole(int userId) {
        try {
            List<UserRoleDto> list = userRoleMapper.getByUserId(userId, ProductTypeEnum.DOCTOR.code());
            String key = Constants.KEY_DOCTOR_ROLE + userId;
            cacheClient.del(key);  //先删除，后新增
            for (UserRoleDto dto : list) {
                cacheClient.sadd(key, dto.getRoleCode());
            }
            cacheClient.expire(key, Constants.EXPIRE_TIMES);  //缓存过期时间30天
        } catch (Exception ex) {
            logger.error(ex.getMessage(), ex);
        }
    }

}
