package com.pica.cloud.permission.permission.server.service.impl;

import com.pica.cloud.foundation.entity.PicaException;
import com.pica.cloud.foundation.entity.PicaResultCode;
import com.pica.cloud.permission.permission.server.constants.Constants;
import com.pica.cloud.permission.permission.server.entity.Resource;
import com.pica.cloud.permission.permission.server.mapper.ResourceMapper;
import com.pica.cloud.permission.permission.server.mapper.RoleResourceMapper;
import com.pica.cloud.permission.permission.server.service.PermissionCacheService;
import com.pica.cloud.permission.permission.server.service.ResourceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import java.util.Date;
import java.util.List;

/**
 * @author andong
 * @create 2019/8/30
 */
@Service
public class ResourceServiceImpl implements ResourceService {

    @Autowired
    private PermissionCacheService permissionCacheService;
    @Autowired
    private ResourceMapper resourceMapper;
    @Autowired
    private RoleResourceMapper roleResourceMapper;

    @Override
    @Transactional
    public void addResource(Resource resource) {
        resource.setModifiedId(resource.getCreatedId());
        resource.setCreatedTime(new Date());
        resource.setModifiedTime(resource.getCreatedTime());
        resourceMapper.insertSelective(resource);
    }

    @Override
    public Resource getById(int id) {
        return resourceMapper.selectByPrimaryKey(id);
    }

    @Override
    @Transactional
    public void updateResource(Resource resource) {
        Resource origin = resourceMapper.selectByPrimaryKey(resource.getId());
        if (origin == null) {
            throw new PicaException(PicaResultCode.DATA_EXCEPTION.code(), "资源不存在");
        }
        resource.setProductType(null);  //不支持修改产品线类型
        resource.setType(null);  //不支持修改资源类型
        resource.setModifiedTime(new Date());
        resourceMapper.updateByPrimaryKeySelective(resource);
        permissionCacheService.updateResource(origin, resource);  //更新缓存信息
    }

    @Override
    public List<Resource> getByCriteria(Resource resource) {
        return resourceMapper.selectByCriteria(resource);
    }

    @Override
    @Transactional
    public void deleteResource(int id, int modifiedId) {
        Integer pk = roleResourceMapper.checkResourceUsed(id);
        if (pk != null) {
            throw new PicaException(PicaResultCode.DATA_EXCEPTION.code(), "资源已被使用，无法删除");
        }
        Resource resource = new Resource();
        resource.setId(id);
        resource.setDeleteFlag(Constants.DELETE_FLAG_INVALID);
        resource.setModifiedId(modifiedId);
        resource.setModifiedTime(new Date());
        resourceMapper.updateByPrimaryKeySelective(resource);
    }
}
