package com.pica.cloud.permission.permission.server.service.impl;

import com.pica.cloud.foundation.entity.PicaException;
import com.pica.cloud.foundation.entity.PicaResultCode;
import com.pica.cloud.permission.permission.server.constants.Constants;
import com.pica.cloud.permission.permission.server.entity.DataPrivilege;
import com.pica.cloud.permission.permission.server.mapper.DataPrivilegeMapper;
import com.pica.cloud.permission.permission.server.mapper.RoleResourceMapper;
import com.pica.cloud.permission.permission.server.service.DataPrivilegeService;
import com.pica.cloud.permission.permission.server.service.PermissionCacheService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import java.util.Date;
import java.util.List;

/**
 * @author andong
 * @create 2019/9/2
 */
@Service
public class DataPrivilegeServiceImpl implements DataPrivilegeService {

    @Autowired
    private PermissionCacheService permissionCacheService;
    @Autowired
    private DataPrivilegeMapper dataPrivilegeMapper;
    @Autowired
    private RoleResourceMapper roleResourceMapper;

    @Override
    @Transactional
    public void addDataPrivilege(DataPrivilege dataPrivilege) {
        dataPrivilege.setModifiedId(dataPrivilege.getCreatedId());
        dataPrivilege.setCreatedTime(new Date());
        dataPrivilege.setModifiedTime(dataPrivilege.getCreatedTime());
        dataPrivilegeMapper.insertSelective(dataPrivilege);
    }

    @Override
    public DataPrivilege getById(int id) {
        return dataPrivilegeMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<DataPrivilege> getByResourceId(int resourceId) {
        return dataPrivilegeMapper.getByResourceId(resourceId);
    }

    @Override
    @Transactional
    public void updateDataPrivilege(DataPrivilege dataPrivilege) {
        DataPrivilege origin = dataPrivilegeMapper.selectByPrimaryKey(dataPrivilege.getId());
        if (origin == null) {
            throw new PicaException(PicaResultCode.DATA_EXCEPTION.code(), "数据权限不存在");
        }
        dataPrivilege.setResourceId(null);  //不支持修改资源ID
        dataPrivilege.setModifiedTime(new Date());
        dataPrivilegeMapper.updateByPrimaryKeySelective(dataPrivilege);
        permissionCacheService.updateDataPrivilege(origin, dataPrivilege);  //更新缓存信息
    }

    @Override
    @Transactional
    public void deleteDataPrivilege(int id, int modifiedId) {
        Integer pk = roleResourceMapper.checkDataPrivilegeUsed(id);
        if (pk != null) {
            throw new PicaException(PicaResultCode.DATA_EXCEPTION.code(), "数据权限已被使用，无法删除");
        }
        DataPrivilege dataPrivilege = new DataPrivilege();
        dataPrivilege.setId(id);
        dataPrivilege.setDeleteFlag(Constants.DELETE_FLAG_INVALID);
        dataPrivilege.setModifiedId(modifiedId);
        dataPrivilege.setModifiedTime(new Date());
        dataPrivilegeMapper.updateByPrimaryKeySelective(dataPrivilege);
    }
}
