package com.pica.cloud.permission.permission.server.validation;

import com.pica.cloud.foundation.entity.PicaException;
import com.pica.cloud.foundation.entity.PicaResultCode;
import com.pica.cloud.permission.permission.common.constants.AuthTypeEnum;
import com.pica.cloud.permission.permission.common.constants.ProductTypeEnum;
import com.pica.cloud.permission.permission.common.dto.AuthDto;
import com.pica.cloud.permission.permission.common.dto.GrantDto;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.CollectionUtils;

/**
 * @author andong
 * @create 2019/9/5
 */
public class PermissionValidation {

    public static void grantValidate(GrantDto grantDto) {
        if (grantDto.getUserId() <= 0) {
            throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "用户ID不正确");
        }
        if (StringUtils.isBlank(grantDto.getGrantCode())) {
            throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "授权场景编码为空");
        }
        if (grantDto.getCreatedId() <= 0) {
            throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "操作人ID为空");
        }
    }

    public static void authValidate(AuthDto authDto) {
        int productType = authDto.getProductType();
        if (productType != ProductTypeEnum.DOCTOR.code() && productType != ProductTypeEnum.HEALTH.code()
                && productType != ProductTypeEnum.ADMIN.code()) {
            throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "产品线类型不正确");
        }
        if (authDto.getUserId() <= 0) {
            throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "用户ID不正确");
        }
        if (authDto.getAuthType() != AuthTypeEnum.ROLE.code() && authDto.getAuthType() != AuthTypeEnum.URL.code()) {
            throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "鉴权类型不正确");
        }
        if (authDto.getAuthType() == AuthTypeEnum.ROLE.code() && CollectionUtils.isEmpty(authDto.getRoleCodes())) {
            throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "角色编码为空");
        }
        if (authDto.getAuthType() == AuthTypeEnum.URL.code() && StringUtils.isBlank(authDto.getUrl())) {
            throw new PicaException(PicaResultCode.PARAM_IS_BLANK.code(), "资源url为空");
        }
    }

}
