package com.pica.cloud.permission.permission.server.controller;

import com.pica.cloud.foundation.entity.PicaResponse;
import com.pica.cloud.permission.permission.common.dto.AuthDto;
import com.pica.cloud.permission.permission.common.dto.AuthResultDto;
import com.pica.cloud.permission.permission.common.dto.GrantDto;
import com.pica.cloud.permission.permission.server.service.PermissionService;
import com.pica.cloud.permission.permission.server.validation.PermissionValidation;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author andong
 * @create 2019/8/29
 */
@Api(description = "权限管理")
@RestController
@RequestMapping("/permission")
public class PermissionController {

    @Autowired
    private PermissionService permissionService;

    @GetMapping("/test")
    public PicaResponse<String> test() {
        return PicaResponse.toResponse("test");
    }

    @ApiOperation("授权")
    @PostMapping("/grant")
    public PicaResponse grant(@RequestBody GrantDto grantDto) {
        PermissionValidation.grantValidate(grantDto);
        return null;
    }

    @ApiOperation("授权")
    @PostMapping("/auth")
    public PicaResponse<AuthResultDto> auth(@RequestBody AuthDto authDto) {
        PermissionValidation.authValidate(authDto);
        AuthResultDto result = permissionService.auth(authDto);
        return PicaResponse.toResponse(result);
    }

}
