package com.pica.cloud.permission.permission.server.service.impl;

import com.pica.cloud.foundation.entity.PicaException;
import com.pica.cloud.foundation.entity.PicaResultCode;
import com.pica.cloud.permission.permission.common.dto.UserRoleDto;
import com.pica.cloud.permission.permission.server.constants.Constants;
import com.pica.cloud.permission.permission.server.entity.Role;
import com.pica.cloud.permission.permission.server.entity.UserRole;
import com.pica.cloud.permission.permission.server.mapper.RoleMapper;
import com.pica.cloud.permission.permission.server.mapper.UserRoleMapper;
import com.pica.cloud.permission.permission.server.service.UserRoleService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import java.util.Date;
import java.util.List;

/**
 * @author andong
 * @create 2019/9/3
 */
@Service
public class UserRoleServiceImpl implements UserRoleService {

    @Autowired
    private UserRoleMapper userRoleMapper;
    @Autowired
    private RoleMapper roleMapper;

    @Override
    @Transactional
    public void addUserRole(UserRoleDto userRoleDto) {
        Role role;
        if (userRoleDto.getRoleId() != null) {
            role = roleMapper.selectByPrimaryKey(userRoleDto.getRoleId());
        } else {
            role = roleMapper.getByCode(userRoleDto.getRoleCode());
        }
        if (role == null) {
            throw new PicaException(PicaResultCode.RESULE_DATA_NONE.code(), "角色不存在");
        }
        if (role.getProductType().intValue() != userRoleDto.getProductType().intValue()) {
            throw new PicaException(PicaResultCode.PARAM_IS_INVALID.code(), "用户与角色产品线不匹配");
        }

        UserRole userRole = new UserRole();
        BeanUtils.copyProperties(userRoleDto, userRole);
        userRole.setRoleId(role.getId());
        userRole.setModifiedId(userRole.getCreatedId());
        userRole.setCreatedTime(new Date());
        userRole.setModifiedTime(userRole.getCreatedTime());
        userRoleMapper.insertSelective(userRole);
    }

    @Override
    public List<UserRoleDto> getByUserId(int userId, int productType) {
        return userRoleMapper.getByUserId(userId, productType);
    }

    @Override
    @Transactional
    public void deleteById(int id, int modifiedId) {
        UserRole userRole = new UserRole();
        userRole.setId(id);
        userRole.setDeleteFlag(Constants.DELETE_FLAG_INVALID);
        userRole.setModifiedId(modifiedId);
        userRole.setModifiedTime(new Date());
        userRoleMapper.updateByPrimaryKeySelective(userRole);
    }

    @Override
    @Transactional
    public void deleteUserRole(UserRoleDto userRoleDto) {
        UserRole userRole = new UserRole();
        BeanUtils.copyProperties(userRoleDto, userRole);
        if (userRoleDto.getRoleId() == null) {
            Role role = roleMapper.getByCode(userRoleDto.getRoleCode());
            if (role == null) {
                return;
            }
            userRole.setRoleId(role.getId());
        }
        userRoleMapper.deleteUserRole(userRole);
    }
}
