package com.pica.cloud.permission.permission.server.controller;

import com.pica.cloud.foundation.entity.PicaResponse;
import com.pica.cloud.permission.permission.common.dto.UserRoleDto;
import com.pica.cloud.permission.permission.server.service.UserRoleService;
import com.pica.cloud.permission.permission.server.validation.UserRoleValidation;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import java.util.List;

/**
 * @author andong
 * @create 2019/9/3
 */
@Api(description = "用户-角色管理")
@RestController
@RequestMapping("/permission")
public class UserRoleController {

    @Autowired
    private UserRoleService userRoleService;

    @ApiOperation("根据用户ID，产品线类型查询角色列表")
    @GetMapping("/user-role")
    public PicaResponse<List<UserRoleDto>> getByUserId(@RequestParam("userId") int userId, @RequestParam("productType") int productType) {
        List<UserRoleDto> list = userRoleService.getByUserId(userId, productType);
        return PicaResponse.toResponse(list);
    }

    @ApiOperation("添加用户角色关系")
    @PostMapping("/user-role")
    public PicaResponse addUserRole(@RequestBody UserRoleDto userRoleDto) {
        UserRoleValidation.addUserRoleValidate(userRoleDto);
        userRoleService.addUserRole(userRoleDto);
        return PicaResponse.toResponse();
    }

    @ApiOperation("根据主键逻辑删除用户角色关系")
    @DeleteMapping("/user-role")
    public PicaResponse deleteById(@RequestParam("id") int id, @RequestParam("modifiedId") int modifiedId) {
        userRoleService.deleteById(id, modifiedId);
        return PicaResponse.toResponse();
    }

    @ApiOperation("逻辑删除用户角色关系")
    @PutMapping("/user-role")
    public PicaResponse deleteUserRole(@RequestBody UserRoleDto userRoleDto) {
        UserRoleValidation.deleteUserRoleValidate(userRoleDto);
        userRoleService.deleteUserRole(userRoleDto);
        return PicaResponse.toResponse();
    }

}
