package com.pica.cloud.wechat.yunqueyilian.server.configuration;

import com.pica.cloud.foundation.redis.CacheClient;
import com.pica.cloud.foundation.redis.ICacheClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@RefreshScope
public class BeanConfiguration {
    @Autowired
    SpringContextAware springContextAware;

    @Value("${wechat_url}")
    private String wechatUrl;

    public String getWechatUrl() {
        return wechatUrl;
    }

    @Bean
    public ICacheClient cacheClient() {
        return new CacheClient(springContextAware.getActiveProfile());
    }
}
