package com.pica.cloud.wechat.yunqueyilian.server.controller.refresh;

import com.pica.cloud.foundation.entity.PicaResponse;
import com.pica.cloud.foundation.entity.PicaResultCode;
import com.pica.cloud.foundation.utils.entity.PicaUser;
import com.pica.cloud.foundation.utils.annotation.LoginPermission;
import com.pica.cloud.foundation.utils.controller.BaseController;
import com.pica.cloud.wechat.yunqueyilian.server.utils.ReturnUtil;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@Api(value = "刷数据", description = "")
@RestController
@RequestMapping(value = "/refresh")
public class RefreshController extends BaseController {

    @Autowired
    private RefreshService refreshService;


    @LoginPermission
    @PostMapping("/initPatient")
    public PicaResponse initPatient(@RequestParam("id") Integer id) {

        PicaUser picaUser = fetchPicaUser();
        if (picaUser.getId() == 766) {
            refreshService.initPatient(id);
        }

        return ReturnUtil.getPicaResponse(PicaResultCode.SUCCESS);
    }

    @LoginPermission
    @PostMapping("/patDocMapping1")
    public PicaResponse patDocMapping1(@RequestParam("id") Integer id) {

        PicaUser picaUser = fetchPicaUser();
        if (picaUser.getId() == 766) {
            refreshService.patDocMapping1(id);
        }

        return ReturnUtil.getPicaResponse(PicaResultCode.SUCCESS);
    }

    @LoginPermission
    @PostMapping("/patDocMapping2")
    public PicaResponse patDocMapping2(@RequestParam("id") Integer id) {

        PicaUser picaUser = fetchPicaUser();
        if (picaUser.getId() == 766) {
            refreshService.patDocMapping2(id);
        }

        return ReturnUtil.getPicaResponse(PicaResultCode.SUCCESS);
    }
}
