package com.pica.cloud.wechat.yunqueyilian.common.util;

import com.alibaba.fastjson.JSON;
import net.sf.json.JSONObject;
import org.apache.http.HttpEntity;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.*;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;


/**
 * @ClassName:HttpclientUtil.java

 * @Description: Httpclient处理类

 * @author bo.dang

 * @date 2016年1月26日 下午2:45:52

 * @version V1.0


 */
public class HttpClientUtil {

    private static final Logger logger = LoggerFactory.getLogger(HttpClientUtil.class);
    private static final CloseableHttpClient hc;

    static {
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();

        cm.setDefaultMaxPerRoute(20);
        cm.setMaxTotal(200);

        hc = HttpClients.custom().setConnectionManager(cm).build();
    }

    public static int postForm(String url, Map<String, String> params, HttpEntity entity) throws IOException {
        HttpPost post = new HttpPost(url);
        for(Map.Entry<String, String> param : params.entrySet()) {
            post.setHeader(param.getKey(), param.getValue());
        }
        post.setEntity(entity);
        CloseableHttpResponse resp = null;
        try {
            resp = hc.execute(post);
            return resp.getStatusLine().getStatusCode();
        } catch(Exception e){
            logger.error("异常抛出exception ", e);
        } finally {
            if(resp != null) {
                try {
                    resp.close();
                } catch (IOException e1) {
                    logger.error("异常抛出exception ", e1);
                }
            }
        }
        return 0;
    }

    public static String httpExecute(String url, String data){
        String result = "";

        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        try {
            httpClient = HttpClients.createDefault();

            HttpPost postRequest = new HttpPost(url);

            postRequest.setHeader("Content-Type","application/json;charset=utf-8");
            postRequest.setHeader("Accept", "application/json");
            //StringEntity input = new StringEntity("{\"token\":\"08b7377d22a88a8951e66ce97f4a06f6\"}");
            StringEntity input = new StringEntity(data, ContentType.APPLICATION_JSON);
            logger.info("data:" + data);
            postRequest.setEntity(input);

            response = httpClient.execute(postRequest);
            if (response.getStatusLine().getStatusCode() != 201) {
                int statusCode = response.getStatusLine().getStatusCode();

                if (statusCode == HttpStatus.SC_OK) {
                    result = EntityUtils.toString(response.getEntity(), "utf-8");
                } else {
                    logger.warn("调用失败，param:{}, result:{}", JSON.toJSONString(data), JSON.toJSONString(response));
                }
            }
            logger.info("response:" + response);
        } catch (Exception e) {
            logger.error("获取session出错:" + e);
        } finally {
            try {
                if(response != null) {
                    response.close();
                }
            } catch (Exception e){
                logger.warn("CloseableHttpResponse关闭异常");
            }
        }
        return result;
    }


    public static String httpExecute(String url, String data,Map map){
        String result = "";

        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        try {
            httpClient = HttpClients.createDefault();

            HttpPost postRequest = new HttpPost(url);

            postRequest.setHeader("Content-Type","application/json;charset=utf-8");
            postRequest.setHeader("Accept", "application/json");
            StringEntity input = new StringEntity(data, ContentType.APPLICATION_JSON);
            logger.warn("{}-{} data:{}", map.get("module"),map.get("type"), data);
            postRequest.setEntity(input);

            response = httpClient.execute(postRequest);
            if (response.getStatusLine().getStatusCode() != 201) {
                int statusCode = response.getStatusLine().getStatusCode();

                if (statusCode == HttpStatus.SC_OK) {
                    result = EntityUtils.toString(response.getEntity(), "utf-8");
                } else {
                    logger.warn("{}-{} 调用失败，param:{}, result:{}", map.get("module"),map.get("type"), JSON.toJSONString(data), JSON.toJSONString(response));
                }
            }
            logger.warn("{}-{} response:{}", map.get("module"),map.get("type"), JSON.toJSONString(response));
        } catch (Exception e) {
            logger.error("{}-{} 获取session出错:", map.get("module"), map.get("type"), e);
        } finally {
            try {
                if(response != null) {
                    response.close();
                }
            } catch (Exception e){
                logger.warn("{}-{} CloseableHttpResponse关闭异常", map.get("module"), map.get("type"), e);
            }
        }
        return result;
    }






    /**
     * 发起http请求并获取结果
     *
     * @param requestUrl 请求地址
     * @param requestMethod 请求方式（GET、POST）
     * @param outputStr 提交的数据
     * @return JSONObject(通过JSONObject.get(key)的方式获取json对象的属性值)
     */
    public static JSONObject httpRequest(String requestUrl, String requestMethod, String outputStr) {
        JSONObject jsonObject = null;
        StringBuffer buffer = new StringBuffer();
        HttpURLConnection httpUrlConn = null;
        BufferedReader bufferedReader = null;
        InputStream inputStream = null;
        InputStreamReader inputStreamReader = null;
        try {

            URL url = new URL(requestUrl);
            httpUrlConn = (HttpURLConnection) url.openConnection();

            httpUrlConn.setDoOutput(true);
            httpUrlConn.setDoInput(true);
            httpUrlConn.setUseCaches(false);
            // 设置请求方式（GET/POST）
            httpUrlConn.setRequestMethod(requestMethod);

            if ("GET".equalsIgnoreCase(requestMethod)) {
                httpUrlConn.connect();
            }

            // 当有数据需要提交时
            if (null != outputStr) {
                OutputStream outputStream = httpUrlConn.getOutputStream();
                // 注意编码格式，防止中文乱码
                outputStream.write(outputStr.getBytes("UTF-8"));
                outputStream.close();
            }

            // 将返回的输入流转换成字符串
            inputStream  = httpUrlConn.getInputStream();
            inputStreamReader = new InputStreamReader(inputStream, "utf-8");
            bufferedReader = new BufferedReader(inputStreamReader);

            String str = null;
            while ((str = bufferedReader.readLine()) != null) {
                buffer.append(str);
            }
            logger.info(buffer.toString());
            jsonObject = JSONObject.fromObject(buffer.toString());
        } catch (ConnectException ce) {
            logger.error("Weixin server connection timed out.");
        } catch (Exception e) {
            logger.error("https request error:{}", e);
        } finally {
            try {
                if(bufferedReader != null){
                    bufferedReader.close();
                }
                if(inputStreamReader != null) {
                    inputStreamReader.close();
                }
                if(inputStream != null) {
                    inputStream.close();
                }
                if(httpUrlConn != null) {
                    httpUrlConn.disconnect();
                }

            } catch (Exception e){
                logger.warn("httpUrlConn关闭异常");
            }
        }
        return jsonObject;
    }


}
