package com.pica.cloud.wechat.yunqueyilian.server.controller;

import com.pica.cloud.foundation.utils.controller.BaseController;
import com.pica.cloud.wechat.yunqueyilian.server.service.CoreService;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

/**
 * @author: zhehao.chen
 * @version: V1.0
 * @Description:
 * @date: 2018/8/9 10:08
 */
@RestController
@RequestMapping("/core")
public class CoreController extends BaseController {
    private static Logger logger = LoggerFactory.getLogger(CoreController.class);

    @Autowired
    private CoreService coreService;

    @ApiOperation(value = "微信验证接口", response = String.class)
    @RequestMapping(method = RequestMethod.GET, produces = "text/xml;charset=UTF-8")
//    @RequestMapping
    public String check(final HttpServletRequest request) throws Exception {
        // 创建一个ResponseBuilder
        return coreService.requestCheck(request);// 返回Response
    }

    @ApiOperation(value = "微信推送事件接口", response = String.class)
    @RequestMapping(method = RequestMethod.POST, produces = "text/xml;charset=UTF-8")
//    @RequestMapping
    public String msg(final HttpServletRequest request) throws Exception {
        // 创建一个ResponseBuilder
        return coreService.processRequest(request);// 返回Response
    }
}
