package com.pica.cloud.wechat.yunqueyilian.server.service.impl;


import com.pica.cloud.wechat.yunqueyilian.common.constants.WeChatConstants;
import com.pica.cloud.wechat.yunqueyilian.common.util.CloudPropertiesUtil;
import com.pica.cloud.wechat.yunqueyilian.common.util.WeChatToolUtil;
import com.pica.cloud.wechat.yunqueyilian.common.wechat.pojo.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;


/**
 * @author: zhehao.chen
 * @version: V1.0
 * @Description:菜单管理器类
 * @date: 2018/8/10 18:12
 */
public class MenuManagerServiceImpl {
    private static Logger log = LoggerFactory.getLogger(MenuManagerServiceImpl.class);

    public static void main(String[] args) throws IOException {
//        CloudPropertiesUtil.read("dev");
        CloudPropertiesUtil.read("pro");
        AccessToken accessToken = WeChatToolUtil.getAccessToken(CloudPropertiesUtil.getValue("AppID"), CloudPropertiesUtil.getValue("AppSecret"));
        Boolean flag = WeChatToolUtil.createMenu(getMenu(), accessToken.getAccess_token());
        if (flag) {
            System.out.println("菜单创建成功");
        } else {
            System.out.println("菜单创建失败");
        }
    }


    /**
     * 组装菜单数据
     *
     * @return
     */
    private static Menu getMenu() throws UnsupportedEncodingException {
        //test1
//        String btn11Url = "https://test1-yunqueyilian.yunqueyi.com/message";
//        String btn21Url = "http://mp.weixin.qq.com/mp/homepage?__biz=MzIzNjM5NDA1OQ==&hid=2&sn=f52aa8659aa75f32aae5ea62d23e64ca&scene=18#wechat_redirect";
//        String btn31Url = "https://test1-yunqueyilian.yunqueyi.com/goBind";
//        String btn32Url = "https://test1-yunqueyilian.yunqueyi.com/applyIndex";
//        String btn33Url = "https://test1-yunqueyilian.yunqueyi.com/followUp";

        //pro
        String btn11Url = "https://yunqueyilian.yunqueyi.com/message";
        String btn21Url = "http://mp.weixin.qq.com/mp/homepage?__biz=MzIzNjM5NDA1OQ==&hid=2&sn=f52aa8659aa75f32aae5ea62d23e64ca&scene=18#wechat_redirect";
        String btn31Url = "https://yunqueyilian.yunqueyi.com/goBind";
        String btn32Url = "https://yunqueyilian.yunqueyi.com/applyIndex";
        String btn33Url = "https://yunqueyilian.yunqueyi.com/followUp";


        String utl_end = "&response_type=code&scope=snsapi_userinfo&state=1#wechat_redirect";
        CommonButton btn11 = new CommonButton();
        btn11.setName("消息");
        btn11.setType("view");
        String url11 = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=" + WeChatConstants.APP_ID + "&redirect_uri=" + URLEncoder.encode(btn11Url, "UTF-8");
        btn11.setUrl(url11 + utl_end);

        CommonButton btn21 = new CommonButton();
        btn21.setName("健康漫画");
        btn21.setType("view");
        String h_knowledge_redirect_uri = btn21Url;
        btn21.setUrl(h_knowledge_redirect_uri);

        CommonButton btn31 = new CommonButton();
        btn31.setName("个人信息");
        btn31.setType("view");
        String url31 = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=" + WeChatConstants.APP_ID + "&redirect_uri=" + URLEncoder.encode(btn31Url, "UTF-8");
        btn31.setUrl(url31 + utl_end);

        CommonButton btn32 = new CommonButton();
        btn32.setName("门诊预约");
        btn32.setType("view");
        String url32 = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=" + WeChatConstants.APP_ID + "&redirect_uri=" + URLEncoder.encode(btn32Url, "UTF-8");
        btn32.setUrl(url32 + utl_end);


        CommonButton btn33 = new CommonButton();
        btn33.setName("随访记录");
        btn33.setType("view");
        String url33 = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=" + WeChatConstants.APP_ID + "&redirect_uri=" + URLEncoder.encode(btn33Url, "UTF-8");
        btn33.setUrl(url33 + utl_end);


        ComplexButton mainBtn3 = new ComplexButton();
        mainBtn3.setName("我的");
        mainBtn3.setSub_button(new CommonButton[]{btn31, btn32, btn33});

        /**
         * 这是公众号xiaoqrobot目前的菜单结构，每个一级菜单都有二级菜单项<br>
         *
         * 在某个一级菜单下没有二级菜单的情况，menu该如何定义呢？<br>
         * 比如，第三个一级菜单项不是“更多体验”，而直接是“幽默笑话”，那么menu应该这样定义：<br>
         * menu.setButton(new Button[] { mainBtn1, mainBtn2, btn33 });
         */
        Menu menu = new Menu();
        menu.setButton(new Button[]{btn11, btn21, mainBtn3});

        return menu;
    }
}