package com.pica.cloud.wechat.yunqueyilian.server.client.impl;

import com.pica.cloud.foundation.entity.PicaResponse;
import com.pica.cloud.foundation.entity.PicaResultCode;
import com.pica.cloud.wechat.yunqueyilian.server.client.IUserServiceClient;
import feign.hystrix.FallbackFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * @author: zhehao.chen
 * @version: V1.0
 * @Description:
 * @date: 2018/8/10 10:57
 */
@Component
public class UserServiceFailFactory implements FallbackFactory<IUserServiceClient> {
    public static final Logger logger = LoggerFactory.getLogger(UserServiceFailFactory.class);

    @Override
    public IUserServiceClient create(Throwable cause) {
        PicaResponse response = (new PicaResponse.Builder<Map<String, Object>>()).build();
        response.setCode(PicaResultCode.INTERFACE_INVOKE_ERROR.code());
        response.setMessage(PicaResultCode.INTERFACE_INVOKE_ERROR.message());

        return new IUserServiceClient() {
            @Override
            public PicaResponse users(String wechatName, String openId) {
                logger.error("service:IUserServiceClient interface:users 触发熔断机制fallback", cause);
                return response;
            }
        };
    }
}
