package com.pica.cloud.wechat.yunqueyilian.server.controller;

import com.pica.cloud.foundation.entity.PicaResponse;
import com.pica.cloud.foundation.redis.ICacheClient;
import com.pica.cloud.foundation.utils.controller.BaseController;
import com.pica.cloud.wechat.yunqueyilian.server.service.CoreService;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisSentinelPool;

import javax.servlet.http.HttpServletRequest;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

/**
 * @author: zhehao.chen
 * @version: V1.0
 * @Description:
 * @date: 2018/8/9 10:08
 */
@RestController
@RequestMapping("/core")
public class CoreController extends BaseController {
    private static Logger logger = LoggerFactory.getLogger(CoreController.class);

    @Autowired
    private CoreService coreService;

    @ApiOperation(value = "微信验证接口", response = String.class)
    @RequestMapping(method = RequestMethod.GET, produces = "text/xml;charset=UTF-8")
//    @RequestMapping
    public String check(final HttpServletRequest request) throws Exception {
        // 创建一个ResponseBuilder
        return coreService.requestCheck(request);// 返回Response
    }

    @ApiOperation(value = "微信推送事件接口", response = String.class)
    @RequestMapping(method = RequestMethod.POST, produces = "text/xml;charset=UTF-8")
//    @RequestMapping
    public String msg(final HttpServletRequest request) throws Exception {
        // 创建一个ResponseBuilder
        return coreService.processRequest(request);// 返回Response
    }

    @Autowired
    private ICacheClient cacheClient;

    @RequestMapping(value = "/redis", method = RequestMethod.GET, produces = "application/json;charset=UTF-8")
    public PicaResponse<Map<String, String>> redis() {
        // http://localhost:11501/hospital/hospitals/redis
        // cluster
        String uuidValue = UUID.randomUUID().toString().substring(0, 8);
        String uuidKey = UUID.randomUUID().toString().substring(0, 8);
        System.out.println("cluster - key:" + uuidKey + " value:" + uuidValue);
        cacheClient.set(uuidKey, uuidValue);
        System.out.println("cluster - " + cacheClient.get(uuidKey));

        // sentinel
        Set<String> set1 = new HashSet<>();
        set1.add("192.168.140.27:17000");
        set1.add("192.168.140.28:17000");
        set1.add("192.168.140.29:17000");
        JedisSentinelPool pool1 = new JedisSentinelPool("master01", set1, "Uu49Kz1olY85HQBu");
        Jedis jedis1 = pool1.getResource();
        System.out.println("sentinel dev - " + jedis1.get(uuidKey));

        Set<String> set2 = new HashSet<>();
        set2.add("192.168.110.68:17000");
        set2.add("192.168.110.69:17001");
        set2.add("192.168.110.70:17002");
        JedisSentinelPool pool2 = new JedisSentinelPool("master01", set2, "Uu49Kz1olY85HQBu");
        Jedis jedis2 = pool2.getResource();
        System.out.println("sentinel test - " + jedis2.get(uuidKey));

        Set<String> set3 = new HashSet<>();
        set3.add("192.168.110.177:17000");
        set3.add("192.168.110.178:17000");
        set3.add("192.168.110.179:17000");
        JedisSentinelPool pool3 = new JedisSentinelPool("master01", set3, "Uu49Kz1olY85HQBu");
        Jedis jedis3 = pool3.getResource();
        System.out.println("sentinel uat - " + jedis3.get(uuidKey));

        cacheClient.del(uuidKey);
        System.out.println("cluster - " + cacheClient.get(uuidKey));

        return PicaResponse.toResponse(uuidValue);
    }
}
