package com.pica.cloud.wechat.yunqueyilian.server.client;

import com.pica.cloud.foundation.entity.PicaResponse;
import com.pica.cloud.wechat.yunqueyilian.server.client.impl.UserServiceFailFactory;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Map;

/**
 * @author: zhehao.chen
 * @version: V1.0
 * @Description:
 * @date: 2018/8/9 13:15
 */
@FeignClient(value = "10102-PICA-CLOUD-WECHAT", fallbackFactory = UserServiceFailFactory.class)
@RequestMapping(value = "/wechats", headers = "sysCode=21", produces = "application/json;charset=UTF-8")
public interface IUserServiceClient {
    @RequestMapping(method = RequestMethod.GET, value = "/users")
    PicaResponse<Map<String, Object>> users(@RequestParam(value = "wechatName") String wechatName, @RequestParam(value = "openId") String openId);
}
