package com.pica.cloud.wechat.yunqueyilian.server.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.pica.cloud.foundation.entity.PicaException;
import com.pica.cloud.foundation.entity.PicaResponse;
import com.pica.cloud.foundation.entity.PicaResultCode;
import com.pica.cloud.foundation.utils.utils.JsonUtil;
import com.pica.cloud.foundation.utils.utils.StringUtil;
import com.pica.cloud.wechat.yunqueyilian.common.CommonUtils;
import com.pica.cloud.wechat.yunqueyilian.common.Constants;
import com.pica.cloud.wechat.yunqueyilian.common.req.TextMessage;
import com.pica.cloud.wechat.yunqueyilian.server.client.IWechatsServiceClient;
import com.pica.cloud.wechat.yunqueyilian.server.configuration.BeanConfiguration;
import com.pica.cloud.wechat.yunqueyilian.server.entity.PWechatUser;
import com.pica.cloud.wechat.yunqueyilian.server.mapper.PWechatUserMapper;
import com.pica.cloud.wechat.yunqueyilian.server.service.CoreService;
import netscape.javascript.JSObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;
import java.util.*;

/**
 * @author: zhehao.chen
 * @version: V1.0
 * @Description:
 * @date: 2018/8/9 10:09
 */
@Service
public class CoreServiceImpl implements CoreService {
    private static Logger logger = LoggerFactory.getLogger(CoreServiceImpl.class);

    @Autowired
    IWechatsServiceClient userServiceClient;

    @Autowired
    PWechatUserMapper wechatUserMapper;

    @Autowired
    BeanConfiguration beanConfigurationl;

    @Override
    public String requestCheck(HttpServletRequest request) {
        // 微信加密签名
        String signature = request.getParameter("signature");
        // 时间戳
        String timestamp = request.getParameter("timestamp");
        // 随机数
        String nonce = request.getParameter("nonce");
        // 随机字符串
        String echostr = request.getParameter("echostr");
        logger.info("微信验证接口信息signature：" + signature + "  timestamp:" + timestamp + "  nonce:" + nonce + "  echostr:" + echostr);
        // 通过检验signature对请求进行校验，若校验成功则原样返回echostr，表示接入成功，否则接入失败
        if (CommonUtils.checkSignature(signature, timestamp, nonce)) {
            return echostr;
        }
        logger.error("微信验证接口异常");
        return null;
    }

    @Override
    public String processRequest(HttpServletRequest request) {
        String respMessage = null;
        try {
            // 默认返回的文本消息内容
            String respContent = "";
            Map<String, String> requestMap = CommonUtils.parseXml(request);// xml请求解析
            // 发送方帐号（open_id）
            String fromUserName = requestMap.get("FromUserName");
            // 公众帐号
            String toUserName = requestMap.get("ToUserName");
            // 消息类型
            String msgType = requestMap.get("MsgType");
            String MsgId = requestMap.get("MsgId");
            String Content = requestMap.get("Content");

            logger.info("requestMap:" + requestMap.toString());

            if (msgType.equals(Constants.REQ_MESSAGE_TYPE_EVENT)) {// 事件推送
                // 事件类型
                String eventType = requestMap.get("Event");
                logger.info("eventType:" + eventType);
                //关注、取消关注流程处理
                if (eventType.equals(Constants.EVENT_TYPE_SUBSCRIBE) || eventType.equals(Constants.EVENT_TYPE_UNSUBSCRIBE)) {
                    String openId = fromUserName;//获得openId
                    Map mapIn = new HashMap();
                    mapIn.put("type", 1);//1云鹊医联
                    mapIn.put("openId", openId);
                    PWechatUser userGet = wechatUserMapper.queryByOpenId(mapIn);//从wechat表中获取数据
                    PicaResponse<Map<String, Object>> response = userServiceClient.users(Constants.WECHAT_NAME_YQYL, openId);  //调用微信的接口，获取微信用户的详细信息
                    logger.info("调用微信接口获取用户信息：" + JSONObject.toJSONString(response));
                    if (!PicaResultCode.SUCCESS.code().equals(response.getCode())) {
                        throw new PicaException(response.getCode(), response.getMessage());
                    }
                    //1.首先处理p_wechat_user表，存在信息就补全，不存在就新增
                    respContent = insertOrUpdataWechatUser(requestMap, response.getData(), userGet);
                }
            }

            if (!StringUtil.isEmpty(respContent)) {
                // 回复消息
                TextMessage textMessage = new TextMessage();
                textMessage.setToUserName(fromUserName);
                textMessage.setFromUserName(toUserName);
                textMessage.setCreateTime(new Date().getTime());
                textMessage.setMsgType(Constants.RESP_MESSAGE_TYPE_TEXT);
                textMessage.setContent(respContent);
                respMessage = CommonUtils.textMessageToXml(textMessage);

                logger.info("textMessage:" + JsonUtil.toJSONString(textMessage));
            }
        } catch (Exception e) {
            logger.error("微信消息处理流程异常", e);
        }

        return respMessage;
    }

    private String insertOrUpdataWechatUser(Map<String, String> requestMap, Map map, PWechatUser wechatUser) throws UnsupportedEncodingException {
        String eventType = requestMap.get("Event");
        if (eventType.equals(Constants.EVENT_TYPE_SUBSCRIBE)) {//关注
            boolean newFlag = false;
            if (StringUtil.isNull(wechatUser)) {//新增
                wechatUser = new PWechatUser();
                newFlag = true;
            }
            wechatUser.setOpenid((String) map.get("openid"));
            wechatUser.setType(1);//1、云鹊医联
            wechatUser.setSex((Integer) map.get("sex"));
            wechatUser.setNickname((String) map.get("nickname"));
            wechatUser.setProvince((String) map.get("province"));
            wechatUser.setCity((String) map.get("city"));
            wechatUser.setCountry((String) map.get("country"));
            wechatUser.setHeadimgurl((String) map.get("headimgurl"));
            wechatUser.setPrivilege((String) map.get("privilege"));
            wechatUser.setUnionid((String) map.get("unionid"));
            wechatUser.setSubscribe((Integer) map.get("subscribe"));
            wechatUser.setLanguage((String) map.get("language"));
            Integer subscribe_time = (Integer) map.get("subscribe_time");
            wechatUser.setSubscribeTime(StringUtil.isNull(subscribe_time) ? new Date() : new Date((long) subscribe_time * 1000));
            wechatUser.setRemark((String) map.get("remark"));
            wechatUser.setGroupid(String.valueOf(map.get("groupid")));
            List tagid_list = (ArrayList) map.get("tagid_list");
            wechatUser.setTagidList(StringUtil.isNull(tagid_list) ? "" : tagid_list.toString());
            wechatUser.setDeleteFlag(1);
            wechatUser.setCreatId(0);
            wechatUser.setModifyId(0);
            if (newFlag) {//新增
                wechatUserMapper.insert(wechatUser);
            } else {//更新
                wechatUserMapper.updateById(wechatUser);
            }

            String url = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=wxcf79dbdc24cb684b"
                    + "&redirect_uri=" + beanConfigurationl.getWechatUrl() + "/goBind"
                    + "&response_type=code&scope=snsapi_userinfo&state=1#wechat_redirect";
            String resContent = "您好！欢迎关注云鹊医联公众号。\n绑定个人资料后可以预约挂号、查看随访记录；还可以收到公众号推送患教和通知。\n<a href='" + url + "'>立即去绑定</a>";

            return resContent;
        } else if (eventType.equals(Constants.EVENT_TYPE_UNSUBSCRIBE)) {//取消关注
            if (StringUtil.isNull(wechatUser)) {//新增
                logger.error("取消关注未能从数据库中获取到用户信息异常");
                return "";
            }
            wechatUser.setSubscribe(0);
            wechatUserMapper.updateSubscribeById(wechatUser);
        }
        return "";
    }

}
