package com.pica.cloud.wechat.yunqueyilian.server.controller.refresh;


import com.pica.cloud.foundation.utils.utils.StringUtil;
import com.pica.cloud.wechat.yunqueyilian.server.mapper.RefreshMapper;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;


/**
 * @Description
 * @Author wangyongbo
 * @Date 2019/9/4 下午4:18
 * @ModifyDate 2019/9/4 下午4:18
 * @Params
 * @Return
 */
@Service
public class RefreshServiceImpl implements RefreshService {

    private static Logger logger = LoggerFactory.getLogger(RefreshServiceImpl.class);

    @Autowired
    private RefreshMapper refreshMapper;


    @Override
    public void initPatient(Integer id) {
        List<PatPatient> reqs = refreshMapper.queryRepeatPat(id);
        int refreshIndex = 0;
        logger.info("开始处理数据：");
        if (CollectionUtils.isNotEmpty(reqs)) {
            for (PatPatient req : reqs) {
                /**获取相同手机号+姓名的居民*/
                List<PatPatient> patList = refreshMapper.queryListPat(req);
                if (CollectionUtils.isNotEmpty(patList)) {
                    List<PatPatient> patRealList = new ArrayList<>();
                    for (PatPatient pat : patList) {
                        /**校验是否有已存在业务，商城、服务包、微信绑定*/
                        if (refreshMapper.validateTradeOrder(pat.getId()) > 0 || refreshMapper.validateAddress(pat.getId()) > 0
                                || refreshMapper.validateFollowUp(pat.getId()) > 0 || refreshMapper.validateWechat(pat.getId()) > 0) {
                            continue;
                        } else {
                            patRealList.add(pat);
                        }
                    }

                    if (CollectionUtils.isNotEmpty(patRealList)) {
                        if (patRealList.size() == patList.size()) {
                            patRealList.remove(0);
                        }
                        if (CollectionUtils.isNotEmpty(patRealList)) {
                            for (PatPatient patReal : patRealList) {
                                if (patReal.getId() != null) {
                                    refreshMapper.deletePat(patReal.getId());
                                    refreshMapper.deletePatInfo(patReal.getId());
                                    refreshMapper.deleteDocPat(patReal.getId());
                                    refreshMapper.deleteDocPatInfo(patReal.getId());
                                    refreshMapper.updateRepeat(patReal);
                                    refreshIndex++;
                                }
                            }
                        }
                    }

                }
            }
        }
        logger.info("共处理数据：" + refreshIndex + "【条】");
    }

    @Override
    public void patDocMapping1(Integer id) {
        List<PatDocPatMapping> list = refreshMapper.queryRepeatPatMaping1(id);
        if (CollectionUtils.isNotEmpty(list)) {
            for (PatDocPatMapping mapping : list) {
                refreshMapper.updatePatMaping1(mapping);
                refreshMapper.updatePatMaping2(mapping);
            }
        }
    }

    @Override
    public void patDocMapping2(Integer id) {
        List<PatDocPatMapping> list = refreshMapper.queryRepeatPatMaping2(id);
        if (CollectionUtils.isNotEmpty(list)) {
            for (PatDocPatMapping mapping : list) {
                refreshMapper.updatePatMaping2(mapping);
            }
        }
    }

    @Override
    public void initPatient2(Integer id) {
        List<PatPatientRepeat> list = refreshMapper.queryRepeatPat2(id);
        int refreshIndex = 0;
        logger.info("开始处理数据：");
        if (CollectionUtils.isNotEmpty(list)) {
            for (PatPatientRepeat repeat : list) {
                if (StringUtil.isNotNull(repeat.getIds())) {
                    String[] strIds = repeat.getIds().split(",");
                    List<PatPatient> patPatients = refreshMapper.queryListPatByIds(strIds);
                    if (CollectionUtils.isNotEmpty(patPatients)) {
                        List<PatPatient> wechatPats = new ArrayList<>();
                        for (PatPatient pat : patPatients) {
                            /**校验是否有已存在业务，商城、服务包、微信绑定*/
                            if (refreshMapper.validateWechat(pat.getId()) > 0 && StringUtil.isNull(pat.getMobilePhone())) {
                                wechatPats.add(pat);
                            } else {
                                if (StringUtil.isNull(pat.getMobilePhone())) {
                                    refreshMapper.deletePat(pat.getId());
                                    refreshMapper.deletePatInfo(pat.getId());
                                    refreshMapper.deleteDocPat(pat.getId());
                                    refreshMapper.deleteDocPatInfo(pat.getId());
                                }
                            }
                        }

                        if (CollectionUtils.isNotEmpty(wechatPats)) {
                            for (PatPatient pat : wechatPats) {
                                refreshMapper.updateRatient(pat.getId());
                                refreshMapper.updateRatientInfo(pat.getId());
                            }
                            refreshMapper.updateRepeatById2(repeat.getId());
                        }

                    }
                }
            }
        }
    }

    @Override
    public void realPat(Integer id) {
        int index = 0;
        int docIndex = 0;
        int docLogIndex = 0;
        long begin = System.currentTimeMillis();
        while (true) {
            List<PatPatientReal> list = refreshMapper.queryRealPatientList(id);
            if (CollectionUtils.isEmpty(list)) {
                long end = System.currentTimeMillis();
                logger.info("刷新数据结束：共处理：【" + index + "】条real，【" + docIndex + "】条docPatReal, 【" + docLogIndex + "】条docPatRealLog，消耗：【" + (end - begin) / 1000 + "】s");
                break;
            }
            for (PatPatientReal realPatient : list) {
                if (refreshMapper.queryRealPatient(realPatient.getPatientId()) == null) {

                    PatPatientReal real = new PatPatientReal();
                    real.setId(realPatient.getId());
                    real.setPatientId(realPatient.getPatientId());
                    real.setNickname(realPatient.getNickname());
                    real.setMobilePhone(realPatient.getMobilePhone());
                    real.setStatus(realPatient.getStatus());

                    real.setDeleteFlag(realPatient.getDeleteFlag());
                    real.setCreatedId(realPatient.getCreatedId());
                    real.setCreatedTime(realPatient.getCreatedTime());
                    real.setModifiedId(realPatient.getModifiedId());
                    real.setModifiedTime(realPatient.getModifiedTime());

                    //验真通过赋值5字段
                    if (realPatient.getStatus() == 2) {
                        //验真类型：1、验证码验真 2、短信回复验真 3、小程序验真 4、手机号姓名跟医生一致自动验真
                        real.setValidateType(realPatient.getValidateType());
                        //验真的验证码：若验真类型是1和2，则有值
                        if (real.getValidateType() == 1 || real.getValidateType() == 2) {
                            real.setValidateCode(realPatient.getValidateCode());
                        }
                        //验真时间
                        real.setValidateTime(realPatient.getModifiedTime());
                        //验真人类型:1、医生 2、居民 和 验真人id
                        if (real.getValidateType() == 1 || real.getValidateType() == 4) {
                            real.setValidateUserType(1);
                            real.setValidateUserId(realPatient.getModifiedId());
                        } else {
                            real.setValidateUserType(2);
                            real.setValidateUserId(realPatient.getPatientId());
                        }
                    }

                    refreshMapper.insertRealPatient(real);
                    index++;

                    /**新增mapping表*/
                    List<PatDocPatReal> patDocList = refreshMapper.queryRealPatDocList(realPatient.getPatientId());
                    if (CollectionUtils.isNotEmpty(patDocList)) {
                        for (PatDocPatReal docPatReal : patDocList) {
                            if (refreshMapper.queryRealPatDoc(docPatReal.getPatientId(), docPatReal.getDoctorId()) == null) {
                                refreshMapper.insertRealDocPat(docPatReal);
                                docIndex++;
                            }

                            refreshMapper.insertRealDocPatLog(docPatReal);
                            docLogIndex++;
                        }
                    }

                    logger.info("开始处理数据：第" + index + "条, patientId=" + realPatient.getPatientId() + "，id=" + realPatient.getId());
                }
            }
        }
    }
}

