package com.pica.cloud.wechat.yunqueyilian.common.util;


import com.pica.cloud.foundation.utils.utils.JsonUtil;
import com.pica.cloud.foundation.utils.utils.StringUtil;
import com.pica.cloud.foundation.utils.utils.date.DateTimeUtils;
import com.pica.cloud.wechat.yunqueyilian.common.constants.WeChatConstants;
import com.pica.cloud.wechat.yunqueyilian.common.wechat.pojo.AccessToken;
import com.pica.cloud.wechat.yunqueyilian.common.wechat.pojo.JsapiTicket;
import com.pica.cloud.wechat.yunqueyilian.common.wechat.pojo.Menu;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.URL;
import java.util.Date;


/**
 * 公众平台通用接口工具类
 *
 * @author bo.dang
 * @date 2013-08-09
 */
public class WeChatToolUtil {
    private static Logger logger = LoggerFactory.getLogger(WeChatToolUtil.class);
    /**
     * access_token
     */
    public static String access_token;

    public static AccessToken accessToken;
    /**
     * 获取access_token的时间
     */
    public static Date get_access_token_time;

    /**
     * 权限签名
     */
    public static JsapiTicket jsapiTicket = null;

    /**
     * 发起https请求并获取结果
     *
     * @param requestUrl    请求地址
     * @param requestMethod 请求方式（GET、POST）
     * @param outputStr     提交的数据
     * @return JSONObject(通过JSONObject.get ( key)的方式获取json对象的属性值)
     */
    public static JSONObject httpRequest(String requestUrl, String requestMethod, String outputStr) {
        JSONObject jsonObject = null;
        StringBuffer buffer = new StringBuffer();
        try {
            // 创建SSLContext对象，并使用我们指定的信任管理器初始化
            TrustManager[] tm = {new MyX509TrustManager()};
            SSLContext sslContext = SSLContext.getInstance("SSL", "SunJSSE");
            sslContext.init(null, tm, new java.security.SecureRandom());
            // 从上述SSLContext对象中得到SSLSocketFactory对象
            SSLSocketFactory ssf = sslContext.getSocketFactory();

            URL url = new URL(requestUrl);
            HttpsURLConnection httpUrlConn = (HttpsURLConnection) url.openConnection();
            httpUrlConn.setSSLSocketFactory(ssf);

            httpUrlConn.setDoOutput(true);
            httpUrlConn.setDoInput(true);
            httpUrlConn.setUseCaches(false);
            // 设置请求方式（GET/POST）
            httpUrlConn.setRequestMethod(requestMethod);

            if ("GET".equalsIgnoreCase(requestMethod))
                httpUrlConn.connect();

            // 当有数据需要提交时
            if (null != outputStr) {
                OutputStream outputStream = httpUrlConn.getOutputStream();
                // 注意编码格式，防止中文乱码
                outputStream.write(outputStr.getBytes("UTF-8"));
                outputStream.close();
            }

            // 将返回的输入流转换成字符串
            InputStream inputStream = httpUrlConn.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "utf-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);

            String str = null;
            while ((str = bufferedReader.readLine()) != null) {
                buffer.append(str);
            }
            bufferedReader.close();
            inputStreamReader.close();
            // 释放资源
            inputStream.close();
            inputStream = null;
            httpUrlConn.disconnect();
            logger.info(buffer.toString());
            jsonObject = JSONObject.fromObject(buffer.toString());
        } catch (ConnectException ce) {
            logger.error("Weixin server connection timed out.");
        } catch (Exception e) {
            logger.error("https request error:{}", e);
        }
        return jsonObject;
    }


    /**
     * 获取access_token
     *
     * @param appid     凭证
     * @param appsecret 密钥
     * @return
     */
    public static AccessToken getAccessToken(String appid, String appsecret) {
        AccessToken accessToken = null;

        String requestUrl = WeChatConstants.ACCESS_TOKEN_URL.replace("APPID", appid).replace("APPSECRET", appsecret);
        JSONObject jsonObject = httpRequest(requestUrl, "GET", null);
        // 如果请求成功
        if (null != jsonObject) {
            try {
                access_token = jsonObject.getString("access_token");
                if (!StringUtil.isEmpty(access_token)) {
                    get_access_token_time = new Date();
                    accessToken = JsonUtil.toGsonBean(jsonObject.toString(), AccessToken.class);
                    logger.info("获取token成功 accessToken:{}", jsonObject.toString());
                } else {
                    get_access_token_time = new Date();
                    logger.error("获取token失败 errcode:{} errmsg:{}", jsonObject.getInt("errcode"), jsonObject.getString("errmsg"));
                }
            } catch (JSONException e) {
                accessToken = null;
                // 获取token失败
                logger.error("获取token失败 errcode:{} errmsg:{}", jsonObject.getInt("errcode"), jsonObject.getString("errmsg"));
            }
        } else {
            // 获取token失败
            logger.error("获取token失败 errcode:{} errmsg:{}", jsonObject.getInt("errcode"), jsonObject.getString("errmsg"));
        }

        WeChatToolUtil.accessToken = accessToken;

        return accessToken;
    }


    /**
     * 校验accessToken是否过期
     *
     * @param access_token
     * @return
     */
    public static AccessToken checkAccessToken(String access_token) {
        AccessToken accessToken = WeChatToolUtil.accessToken;

        if (WeChatToolUtil.isExpired() || StringUtil.isEmpty(access_token)) {
            logger.info("access_token已过期，重新获取 start");
            accessToken = WeChatToolUtil.getAccessToken(WeChatConstants.APP_ID, WeChatConstants.APP_SECRET);
        }
        return accessToken;
    }


    /**
     * 获得jsapi_ticket
     *
     * @return
     */
    public static JsapiTicket getJsapi_ticket() {
        String requestUrl = WeChatConstants.GET_JSAPI_TICKET.replace("ACCESS_TOKEN", access_token);
        JSONObject jsonObject = httpRequest(requestUrl, "GET", null);
        JsapiTicket jsapiTicket = null;
        if (StringUtil.isNotNull(jsonObject)) {
            jsapiTicket = JsonUtil.toGsonBean(jsonObject.toString(), JsapiTicket.class);
        }
        return jsapiTicket;
    }


    /**
     * 创建菜单
     *
     * @param menu        菜单实例
     * @param accessToken 有效的access_token
     * @return 0表示成功，其他值表示失败
     */
    public static Boolean createMenu(Menu menu, String accessToken) {
        Boolean flag = true;
        // 拼装创建菜单的url
        String url = WeChatConstants.MENU_CREATE_URL.replace("ACCESS_TOKEN", accessToken);
        // 将菜单对象转换成json字符串
        String jsonMenu = JSONObject.fromObject(menu).toString();
        // 调用接口创建菜单
        JSONObject jsonObject = httpRequest(url, "POST", jsonMenu);
        if (null != jsonObject) {
            if (0 != jsonObject.getInt("errcode")) {
                flag = false;
                logger.error("创建菜单失败 errcode:{} errmsg:{}", jsonObject.getInt("errcode"), jsonObject.getString("errmsg"));
            } else {
                logger.info("创建菜单成功！ errcode:{} errmsg:{}", jsonObject.getInt("errcode"), jsonObject.getString("errmsg"));
            }
        }
        return flag;
    }

    /**
     * 判断access_token是否过期
     */
    public static Boolean isExpired() {
        if (null != get_access_token_time) {
            logger.info("判断access_token是否过期 get_access_token_time:{} currentTime:{}", DateTimeUtils.DateTimeFormater.format(get_access_token_time), DateTimeUtils.currentDateTime());
            return DateTimeUtils.compare2Date(new Date(), DateTimeUtils.addDateSeconds(get_access_token_time, (7200 - 60) * 1000));
        } else {
            return true;
        }
    }

}