package com.pica.cloud.wechat.yunqueyilian.server.utils;


import com.pica.cloud.foundation.entity.PicaResponse;
import com.pica.cloud.foundation.entity.PicaResultCode;

/**
 * 封装返回参数工具类
 * @author andong
 * @create 2018/7/4
 */
public class ReturnUtil {
    private ReturnUtil(){
        throw new IllegalStateException("Utility class");
    }
    //生成返回信息
    public static <T> PicaResponse<T> getPicaResponse(PicaResultCode picaResultCode) {
        PicaResponse.Builder<T> builder = new PicaResponse.Builder<>();
        return builder.setCode(picaResultCode.code()).setMessage(picaResultCode.message()).build();
    }

    //生成返回信息
    public static <T> PicaResponse<T> getPicaResponse(String code, String message) {
        PicaResponse.Builder<T> builder = new PicaResponse.Builder<>();
        return builder.setCode(code).setMessage(message).build();
    }

    //生成返回信息
    public static <T> PicaResponse<T> getPicaResponse(PicaResultCode picaResultCode, T data) {
        PicaResponse.Builder<T> builder = new PicaResponse.Builder<>();
        return builder.setCode(picaResultCode.code()).setMessage(picaResultCode.message()).setData(data).build();
    }

    //生成返回信息
    public static <T> PicaResponse<T> getPicaResponse(String code, String message, T data) {
        PicaResponse.Builder<T> builder = new PicaResponse.Builder<>();
        return builder.setCode(code).setMessage(message).setData(data).build();
    }

}
