package com.pica.cloud.wechat.yunqueyilian.common.aop;

import com.alibaba.fastjson.JSONObject;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author: zhehao.chen
 * @version: V1.0
 * @Description:
 * @date: 2018/8/21 10:55
 */

@Aspect
@Component
public class PicaLogAspectForXml {

    private static final Logger logger = LoggerFactory.getLogger(PicaLogAspectForXml.class);
    ThreadLocal<Long> startTime = new ThreadLocal();
    ThreadLocal<HttpServletRequest> request = new ThreadLocal();
    ThreadLocal<String> contentType = new ThreadLocal();

    @Pointcut("execution(public * com.pica.cloud..*Controller.*(..))")
    public void weblog() {
    }

    @Around("weblog()")
    public Object doAround(ProceedingJoinPoint pjp) throws Throwable {
        RequestAttributes ra = RequestContextHolder.getRequestAttributes();
        ServletRequestAttributes sra = (ServletRequestAttributes) ra;
        HttpServletRequest request = sra.getRequest();
        this.request.set(request);
        this.contentType.set(request.getHeader("Content-Type"));
        String url = request.getRequestURL().toString();
        String method = request.getMethod();
        String uri = request.getRequestURI();
        String queryString;
        if ("GET".equalsIgnoreCase(method)) {
            queryString = request.getQueryString();
        } else if (!this.parseMultipart()) {
            Gson g = new Gson();
            queryString = g.toJson(this.getBeanFromJsonBody());
        } else {
            queryString = "";
        }

        this.startTime.set(System.currentTimeMillis());
        logger.info("request start, controller params==>, url: {}, method: {}, uri: {}, params: {}", new Object[]{url, method, uri, queryString});
        Object result = pjp.proceed();
        String res = "";
        if (this.contentType.get().equals("text/xml")) {
            res = result.toString();
        } else if (this.contentType.get().equals("application/json")) {
            Gson gson = new Gson();
            res = gson.toJson(result);
        }
        logger.info("request spent time milliSeconds ==>" + (System.currentTimeMillis() - (Long) this.startTime.get()));
        if (this.parseMultipart()) {
            res = "upload/download";
        }
        logger.info("request  over，controller result ==> " + res);
        return result;
    }

    protected Map<String, Object> getBeanFromJsonBody() throws Exception {
        if (this.contentType.get().equals("text/xml")) {
            // 读取输入流
            SAXReader reader = new SAXReader();
            org.dom4j.Document document = reader.read(this.request.get().getInputStream());
            // 得到xml根元素
            Element root = document.getRootElement();
            List<Element> elementList = root.elements();
            // 遍历所有子节点
            Map<String, Object> map = new HashMap<String, Object>();
            for (Element e : elementList)
                map.put(e.getName(), e.getText());
            return map;
        } else if (this.contentType.get().equals("application/json")) {
            Gson gson = new Gson();
            return (Map) gson.fromJson(IOUtils.toString(new InputStreamReader(((HttpServletRequest) this.request.get()).getInputStream(), "utf-8")), (new TypeToken<Map<String, Object>>() {
            }).getType());
        }
        return null;
    }

    protected boolean parseMultipart() throws Exception {
        return ServletFileUpload.isMultipartContent((HttpServletRequest) this.request.get());
    }

    public static String getBodyString(BufferedReader br) {
        String str = "";

        try {
            String inputLine;
            while ((inputLine = br.readLine()) != null) {
                str = str + inputLine;
            }

            br.close();
        } catch (IOException var4) {
            System.out.println("IOException: " + var4);
        }

        return str;
    }

    public static String getHeaderString(HttpServletRequest request) {
        JSONObject jsonObject = new JSONObject();
        Enumeration enu = request.getHeaderNames();

        String str;
        while (enu.hasMoreElements()) {
            str = (String) enu.nextElement();
            String headerValue = request.getHeader(str);
            jsonObject.put(str, headerValue);
            System.out.println(str + ":" + headerValue);
        }

        str = jsonObject.toJSONString();
        return str;
    }
}
