package com.pica.cloud.wechat.yunqueyilian.server.service.impl;

import com.pica.cloud.foundation.utils.utils.StringUtil;
import com.pica.cloud.wechat.yunqueyilian.common.CommonUtils;
import com.pica.cloud.wechat.yunqueyilian.common.Constants;
import com.pica.cloud.wechat.yunqueyilian.common.req.TextMessage;
import com.pica.cloud.wechat.yunqueyilian.server.client.IUserServiceClient;
import com.pica.cloud.wechat.yunqueyilian.server.entity.PWechatUser;
import com.pica.cloud.wechat.yunqueyilian.server.mapper.PWechatUserMapper;
import com.pica.cloud.wechat.yunqueyilian.server.service.CoreService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * @author: zhehao.chen
 * @version: V1.0
 * @Description:
 * @date: 2018/8/9 10:09
 */
@Service
public class CoreServiceImpl implements CoreService {
    private static Logger logger = LoggerFactory.getLogger(CoreServiceImpl.class);

    @Autowired
    IUserServiceClient userServiceClient;

    @Autowired
    PWechatUserMapper wechatUserMapper;

    @Override
    public String requestCheck(HttpServletRequest request) {
        // 微信加密签名
        String signature = request.getParameter("signature");
        // 时间戳
        String timestamp = request.getParameter("timestamp");
        // 随机数
        String nonce = request.getParameter("nonce");
        // 随机字符串
        String echostr = request.getParameter("echostr");
        // 通过检验signature对请求进行校验，若校验成功则原样返回echostr，表示接入成功，否则接入失败
        if (CommonUtils.checkSignature(signature, timestamp, nonce)) {
            return echostr;
        }
        return null;
    }

    @Override
    public String processRequest(HttpServletRequest request) {
        String respMessage = null;
        try {
            // 默认返回的文本消息内容
            String respContent = "";
            Map<String, String> requestMap = CommonUtils.parseXml(request);// xml请求解析
            // 发送方帐号（open_id）
            String fromUserName = requestMap.get("FromUserName");
            // 公众帐号
            String toUserName = requestMap.get("ToUserName");
            // 消息类型
            String msgType = requestMap.get("MsgType");
            String MsgId = requestMap.get("MsgId");
            String Content = requestMap.get("Content");

            logger.info("requestMap:" + requestMap.toString());

            if (msgType.equals(Constants.REQ_MESSAGE_TYPE_EVENT)) {// 事件推送
                // 事件类型
                String eventType = requestMap.get("Event");
                logger.info("eventType:" + eventType);
                //关注流程处理
                if (eventType.equals(Constants.EVENT_TYPE_SUBSCRIBE)) {
                    //获得openId
                    String openId = fromUserName;
                    //调用微信的接口，获取微信用户的详细信息
                    Map map = userServiceClient.users(Constants.WECHAT_NAME_YQYL, openId);
                    logger.info(map.toString());
                    //1.首先处理p_wechat_user表，存在信息就补全，不存在就新增
//                    insertOrUpdataWechatDoctor(requestMap, map, userGet);
                }
                // 取消订阅
                else if (eventType.equals(Constants.EVENT_TYPE_UNSUBSCRIBE)) {
                    String openId = fromUserName;//获得openId
                    Map mapIn = new HashMap();
                    mapIn.put("type", 1);//1云鹊医联
                    mapIn.put("openId", openId);
                    PWechatUser userGet = wechatUserMapper.queryByOpenId(mapIn);//从wechat表中获取数据
                    Map map = userServiceClient.users(Constants.WECHAT_NAME_YQYL, openId);  //调用微信的接口，获取微信用户的详细信息
                    logger.info(map.toString());
                    //1.首先处理p_wechat_user表，存在信息就补全，不存在就新增
//                    insertOrUpdataWechatDoctor(requestMap, map, userGet);
                }
                // 自定义菜单点击事件
                else if (eventType.equals(Constants.EVENT_TYPE_CLICK)) {
                    // 事件KEY值，与创建自定义菜单时指定的KEY值对应
                    String eventKey = requestMap.get("EventKey");
                    logger.info("eventKey:" + eventKey);
                    if (eventKey.equals("11")) {
                    } else if (eventKey.equals("12")) {
                        respContent = "12客官别急，功能正在升级中...";
                    } else if (eventKey.equals("13")) {
                        respContent = "13客官别急，功能正在升级中...";
                    }
                }
            }

            if (!StringUtil.isEmpty(respContent)) {
                // 回复消息
                TextMessage textMessage = new TextMessage();
                textMessage.setToUserName(fromUserName);
                textMessage.setFromUserName(toUserName);
                textMessage.setCreateTime(new Date().getTime());
                textMessage.setMsgType(Constants.RESP_MESSAGE_TYPE_TEXT);
                textMessage.setContent(respContent);
                respMessage = CommonUtils.textMessageToXml(textMessage);

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return respMessage;
    }
}
