package com.pica.cloud.wechat.yunqueyilian.server.controller.refresh;


import com.pica.cloud.foundation.utils.utils.StringUtil;
import com.pica.cloud.wechat.yunqueyilian.server.mapper.RefreshMapper;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;


/**
 * @Description
 * @Author wangyongbo
 * @Date 2019/9/4 下午4:18
 * @ModifyDate 2019/9/4 下午4:18
 * @Params
 * @Return
 */
@Service
public class RefreshServiceImpl implements RefreshService {

    private static Logger logger = LoggerFactory.getLogger(RefreshServiceImpl.class);

    @Autowired
    private RefreshMapper refreshMapper;


    @Override
    public void initPatient(Integer id) {
        List<PatPatient> reqs = refreshMapper.queryRepeatPat(id);
        int refreshIndex = 0;
        logger.info("开始处理数据：");
        if (CollectionUtils.isNotEmpty(reqs)) {
            for (PatPatient req : reqs) {
                /**获取相同手机号+姓名的居民*/
                List<PatPatient> patList = refreshMapper.queryListPat(req);
                if (CollectionUtils.isNotEmpty(patList)) {
                    List<PatPatient> patRealList = new ArrayList<>();
                    for (PatPatient pat : patList) {
                        /**校验是否有已存在业务，商城、服务包、微信绑定*/
                        if (refreshMapper.validateTradeOrder(pat.getId()) > 0 || refreshMapper.validateAddress(pat.getId()) > 0
                                || refreshMapper.validateFollowUp(pat.getId()) > 0 || refreshMapper.validateWechat(pat.getId()) > 0) {
                            continue;
                        } else {
                            patRealList.add(pat);
                        }
                    }

                    if (CollectionUtils.isNotEmpty(patRealList)) {
                        if (patRealList.size() == patList.size()) {
                            patRealList.remove(0);
                        }
                        if (CollectionUtils.isNotEmpty(patRealList)) {
                            for (PatPatient patReal : patRealList) {
                                if (patReal.getId() != null) {
                                    refreshMapper.deletePat(patReal.getId());
                                    refreshMapper.deletePatInfo(patReal.getId());
                                    refreshMapper.deleteDocPat(patReal.getId());
                                    refreshMapper.deleteDocPatInfo(patReal.getId());
                                    refreshMapper.updateRepeat(patReal);
                                    refreshIndex++;
                                }
                            }
                        }
                    }

                }
            }
        }
        logger.info("共处理数据：" + refreshIndex + "【条】");
    }

    @Override
    public void patDocMapping1(Integer id) {
        List<PatDocPatMapping> list = refreshMapper.queryRepeatPatMaping1(id);
        if (CollectionUtils.isNotEmpty(list)) {
            for (PatDocPatMapping mapping : list) {
                refreshMapper.updatePatMaping1(mapping);
                refreshMapper.updatePatMaping2(mapping);
            }
        }
    }

    @Override
    public void patDocMapping2(Integer id) {
        List<PatDocPatMapping> list = refreshMapper.queryRepeatPatMaping2(id);
        if (CollectionUtils.isNotEmpty(list)) {
            for (PatDocPatMapping mapping : list) {
                refreshMapper.updatePatMaping2(mapping);
            }
        }
    }

    @Override
    public void initPatient2(Integer id) {
        List<PatPatientRepeat> list = refreshMapper.queryRepeatPat2(id);
        int refreshIndex = 0;
        logger.info("开始处理数据：");
        if (CollectionUtils.isNotEmpty(list)) {
            for (PatPatientRepeat repeat : list) {
                if (StringUtil.isNotNull(repeat.getIds())) {
                    String[] strIds = repeat.getIds().split(",");
                    List<PatPatient> patPatients = refreshMapper.queryListPatByIds(strIds);
                    if (CollectionUtils.isNotEmpty(patPatients)) {
                        for (PatPatient pat : patPatients) {
                            /**校验是否有已存在业务，商城、服务包、微信绑定*/
                            if (refreshMapper.validateTradeOrder(pat.getId()) > 0 || refreshMapper.validateAddress(pat.getId()) > 0
                                    || refreshMapper.validateFollowUp(pat.getId()) > 0) {
                                continue;
                            } else {
                                if (refreshMapper.validateWechat(pat.getId()) > 0) {
                                    refreshMapper.updateRatient(pat.getId());
                                    refreshMapper.updateRatientInfo(pat.getId());
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

