package com.pica.cloud.wechat.yunqueyilian.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

/**
 * @author: zhehao.chen
 * @version: V1.0
 * @Description:
 * @date: 2018/8/13 9:57
 */
public class CloudPropertiesUtil {

    private static Properties proper = new Properties();

    public CloudPropertiesUtil() {
    }

    public static void read(String env) throws IOException {
        if (env.equals("dev")) {
            load("bootstrap-dev.properties");
        } else if (env.equals("test1")) {
            load("bootstrap-test1.properties");
        } else if (env.equals("test2")) {
            load("bootstrap-test2.properties");
        } else if (env.equals("uat")) {
            load("bootstrap-uat.properties");
        } else if (env.equals("pro")) {
            load("bootstrap-prod.properties");
        }

    }

    public static void load(String file) throws IOException {
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(file);
        proper.load(stream);
    }

    public static String getValue(String key) {
        return proper.getProperty(key);
    }

    public static Integer getIntValue(String key) {
        return Integer.valueOf(proper.getProperty(key));
    }

    public static void updateProperties(String key, String value) {
        proper.setProperty(key, value);
    }
}
