import request from './api';
const cookies = require('cookie-universal')();

// 获取热门搜索关键字
export const getHotLabelsService = async ( data ) => {
  return request({
    // data: data,
    params: data,
    url: 'contents/searchKeyword/listKeywords',
    withCredentials: true
  })
}

// 获取个人的历史搜索关键字
export const getListHistorys = async ( data ) => {
  return request({
    params: data,
    url: 'contents/searchHistory/listHistory',
    withCredentials: true
  })
}

// 批量删除历史搜索关键字
export const delHistorysService = async ( data ) => {
  return request({
    method: 'post',
    data: data,
    url: 'contents/searchHistory/deleteHistory',
    withCredentials: true
  })
}

// 搜索操作
export const sousuoSearch = async ( data ) => {
  data.appVersion = cookies.get('appVersion')
  return request({
    params: data,
    url: `contents/searchKeyword/v2/search`,
    withCredentials: true
  })
}

// 获取推荐课程
export const getRecommendCourseList = async ( data ) => {
  return request({
    params: data,
    url: `contents/courses/recommendCourseList`,
    withCredentials: true
  })
}

// 收藏/取消收藏课程
export const favorsCourse = async ( data ) => {
  return request({
    method: 'post',
    data: data,
    url: `contents/favors`,
    withCredentials: true
  })
}



