import { ENV_CONFIG } from './enumerate';
import { sousuoSearch } from '@/service';

const { NUXT_ENV_APP } = process.env;

export const getSearchByName = name => {
  const match = RegExp(`[?&]${name}=([^&]*)`).exec(window.location.href);
  return match && decodeURIComponent(match[1].replace(/\+/g, ' '));
};

export const getItem = name => {
  if (!name) return;
  const v = sessionStorage.getItem(name);
  let val = null;
  try {
    val = JSON.parse(v);
  } catch (e) {
    // JSON.parse 失败 后 直接赋v给val;
    val = v;
  }
  return val;
};

export const setItem = (name, value) => {
  if (!name) return;
  if (typeof value !== 'string') {
    value = JSON.stringify(value);
  }
  sessionStorage.setItem(name, value);
};

export const removeItem = name => {
  if (!name) return;
  sessionStorage.removeItem(name);
};

export const getConfigByEvtType = key => {
  return ENV_CONFIG[NUXT_ENV_APP][key];
}

export const getNoticeUrl = url => {
  return `${getConfigByEvtType('noticeUrl')}${url}`;
}

export const getShareUrl = url => {
  return `${getConfigByEvtType('shareUrl')}${url}`;
}

export const setEventByModuleCode = (itemData, token) => {
  let modeCode = itemData.code || '';
  let paramList = itemData.paramList ? itemData.paramList : '';
  if (modeCode === 'M001' || modeCode === 'M002' || modeCode === 'M003') {
    paramList = '';
  } else if (
    modeCode === 'M100' ||
    modeCode === 'M300' ||
    modeCode === 'M500' || modeCode === 'M301'
  ) {
    let urlPara = getUrlParmByCode(paramList, token);
    paramList[0] && (paramList[0].value += urlPara);
    // 前端拼接了数据，原生不用再拼接
    paramList = paramList.slice(0, 1)
  }

  if (typeof paramList === 'string' && !paramList) {
    paramList = [];
  }
  if(paramList.length > 0) {
    paramList[0].value = shurpString(paramList[0].value)
  }
  return paramList;
}

function getUrlParmByCode(paramList, token) {
  if (paramList.length <= 1) return `?token=${token}`;
  let dataStr = '', list = [];
  let str = paramList.length > 0 && paramList[0].value.indexOf('?') > -1 ? '&' : '?';

  for (let i = 1; i < paramList.length; i++) {
    list.push(paramList[i].key + '=' + encodeURI(paramList[i].value));
  }
  dataStr = list.join('&');
	
  if (dataStr !== '') return `${str}${dataStr}&token=${token}`;
  return `${str}token=${token}`;
}

// 去重
function shurpString(url) {
  let preUrl = '', subUrl = '', pSet = null, sArr= [], index = url.indexOf('?');
  if(index > 0) {
    preUrl = url.substr(0, index);
    subUrl = url.substr(index + 1);
    if(subUrl.length > 0) {
      subUrl = subUrl.replace(/\?/g, '&')
      pSet = new Set(subUrl.split('&'))
      sArr = Array.from(pSet);
      return preUrl + '?' + sArr.join('&')
    } else {
      return url;
    }
  } else {
    return url;
  }
}

// export function setEventByModuleCode(itemData){
//   let modeCode = itemData.code || '';
//   let paramList = itemData.paramList ? itemData.paramList : ''
//   if( modeCode === 'M001' || modeCode === 'M002' || modeCode === 'M003') {
//       paramList = ''
//   }else if( modeCode === 'M100' || modeCode === 'M300' ) {
     
//     let urlPara = getUrlParmByCode(paramList);
//     paramList[0] && (paramList[0].value += urlPara);

//   }else if( modeCode === 'M400') {

//       let path = paramList[0]['key'];
//       let v = paramList[0]['value'];
//       let query = setRouterParm(paramList);

//       //console.log(Vue);
//       // this.$router.push({
//       //   path: v,
//       //   query:query
//       // })
//   }
//   if(typeof paramList === 'string' && !paramList){
//       paramList = []
//   }

//   return paramList;
// }

// function getUrlParmByCode(paramList) {
//     if ( paramList.length <= 1) {
//         return ''
//     }
//     let dataStr = ''
//     let list = [];
//     for( let i = 1; i < paramList.length; i ++) {
//         list.push(paramList[i].key + '=' + paramList[i].value)
//     }
//     dataStr = list.join('&')
//     if (dataStr !== '') {
//         return '?' + dataStr
//     }
//     return ''
// }

// 获取用户终端信息
export function getTerminalType() {
  let brow = 'unknow';
  if (navigator.userAgent.indexOf('iPad') > -1) {
    return (brow = 'iPad');
  }
  if (
    navigator.userAgent.indexOf('Android') > -1 ||
    navigator.userAgent.indexOf('Linux') > -1
  ) {
    return (brow = 'android');
  }
  if (navigator.userAgent.indexOf('iPhone') > -1) {
    return (brow = 'iPhone');
  }
  if (navigator.userAgent.indexOf('Trident') > -1) {
    return (brow = 'PC');
  }
  if (navigator.userAgent.indexOf('Presto') > -1) {
    return (brow = 'PC');
  }
  if (navigator.userAgent.indexOf('Chrome') > -1) {
    return (brow = 'PC');
  }
  if (navigator.userAgent.indexOf('AppleWebKit') > -1) {
    return (brow = 'iPad');
  }
  if (
    navigator.userAgent.indexOf('Gecko') > -1 &&
    navigator.userAgent.indexOf('KHTML') == -1
  ) {
    return (brow = 'PC');
  }
  if (navigator.userAgent.indexOf('Mac OS X') > -1) {
    return (brow = 'ios');
  }
  if (navigator.userAgent.indexOf('Safari') == -1) {
    return (brow = 'PC');
  }
  return brow;
}

// 根据条件排序
export async function searchForOrder(searchCategory = '1', searchValue = '', sortItem = 1, sortDir = 1, pageSize = 10, sourceData = [], token) {
  if( pageSize <=0 ) return [];
    let str2 = (searchValue || '').replace(/[\-\_\,\!\|\~\`\(\)\#\$\%\^\&\*\{\}\:\;\"\L\<\>\?]/g, '');// 去掉特殊字符
    let para = {
      searchCategory: searchCategory,
      searchValue: str2,
      keywordColor: 'rgba(244,122,72,1)',
      sortItem: sortItem, // 排序规则 1 学习人数，2 修改时间
      dir: sortDir,       // 方向 1:asc 2: desc
      pageNo: 1,
      pageSize: 100,
      // pageSize: sortItem == 0 ? 100 : pageSize,
      token: token || '',
      setEntry: 'headers',
    }
    let url = 'contents/searchKeyword/v2/search'

    let csourceData = await sousuoSearch(para).then(res => {
      if (res.code == '000000') {
        // 课程
        if(searchCategory.indexOf('1') >= 0) {
            sourceData = (res.data && res.data.contentAppModels) || []
        }
        if(searchCategory.indexOf('2') >= 0) {
            sourceData = handelFive(res.data.fiveMinutesMedicalContentList || [])
        }
        if(searchCategory.indexOf('3') >= 0) {
            sourceData = (res.data && res.data.pCourseDoctorModels) || []
        }
        if(searchCategory.indexOf('4') >= 0) {
            sourceData = res.data.educationContents
        }
      }
      return sourceData || []
    })
    return csourceData
}

//处理5分钟数据 初始化播放状态
export function handelFive(d) {
  for (let i = 0; i < d.length; i++) {
      d[i].play = '0';
  }
  return d;
}

// 从原数组中提取前num个元素
export function spliceCertenNumData(oriData, num) {
  let result = [];
  if (oriData.length === 0 || oriData.length < num) {
    return oriData;
  } else {
    for (let i = 0; i < num; i++) {
      result.push(oriData[i]);
    }
    return result.slice();
  }
}


