export const state = () => ({
  userInfo: {},
  cSearchText: '',
  refreshNum: 1,
  orderNum: 1,
  displayConfig: {            
    courseDisplayFlag: 0,
    courseDisplayContent: '',
    courseDisplayParam: [],
    educationComtentDisplayFlag: 0,
    educationComtentDisplayContent: '',
    educationComtentDisplayParam: {id: 1, name: '高血压', seqNo: "1"},
  },
  allHistoryLabels: [],
})
export const getters = {
  userInfo(state) {
    return state.userInfo
  },
  cSearchText(state) {
    return state.cSearchText
  },
  refreshNum(state) {
    return state.refreshNum
  },
  orderNum(state) {
    return state.orderNum
  },
  displayConfig(state) {
    return state.displayConfig
  },
  allHistoryLabels(state) {
    return state.allHistoryLabels
  }
}
export const mutations = {
  SET_USER_INFO(state, userInfo) {
    state.userInfo  = userInfo
  },
  SET_C_SEARCH_TEXT(state, cSearchText) {
    state.cSearchText  = cSearchText
  },
  SET_REFRESH_NUM(state, refreshNum) {
    state.refreshNum  = refreshNum
  },
  SET_ORDER_NUM(state, orderNum) {
    state.orderNum  = orderNum
  },
  SET_DISPLAY_CONFIG(state, displayConfig) {
    state.displayConfig  = displayConfig
  },
  SET_ALL_HISTORY_LABELS(state, allHistoryLabels) {
    state.allHistoryLabels  = allHistoryLabels
  }
}
export const actions = {
  setUserInfo({ commit },  userInfo) {
    commit('SET_USER_INFO', userInfo);
  },
  setCSearchText({ commit }, cSearchText) {
    commit('SET_C_SEARCH_TEXT', cSearchText);
  },
  setRefreshNum({ commit }, refreshNum) {
    commit('SET_REFRESH_NUM', refreshNum);
  },
  setOrderNum({ commit }, orderNum) {
    commit('SET_ORDER_NUM', orderNum);
  },
  setDisplayConfig({ commit }, displayConfig) {
    commit('SET_DISPLAY_CONFIG', displayConfig);
  },
  setAllHistoryLabels({ commit }, allHistoryLabels) {
    commit('SET_ALL_HISTORY_LABELS', allHistoryLabels);
  },
}