import Vue from 'vue'
import { Dialog, Toast, Popup } from 'vant';
import { BASE_URL } from '@/utils/enumerate';
import '@/utils/rem';
import PicaCallApp from 'pica-call-app';
import PicaTopicStencil from 'pica-topic-stencil';
import WebBuriedPoint, { sendBuriedData } from 'web-buried-point';
import PicaH5Login from 'pica-h5-login';
const cookies = require('cookie-universal')();

Vue.use(PicaCallApp)
   .use(PicaTopicStencil)
   .use(PicaH5Login)
   .use(Dialog)
   .use(Toast)
   .use(Popup);

const { NUXT_ENV_APP } = process.env;
 
Vue.use(WebBuriedPoint, {
   class_name: `sousuo-home-v2-ssr`,
   url: `${BASE_URL[NUXT_ENV_APP]}/file/log/trace1`
});

Vue.prototype.$sendBuriedData = sendBuriedData;
Vue.prototype.$cookies = cookies;


