import pywebio
import pywebio.output as output
import pywebio.input as input
import requests


def main():
    output.put_markdown('# 保险测试页(云鹊流程)'),
    ip = input.input_group("权益人信息",

                           [input.input(label='姓名:', type='text', validate=None, name='user_name', value=None,
                                        action=None,
                                        onchange=None,
                                        placeholder='请输入姓名', required=True, readonly=None, datalist=None,
                                        help_text=None),
                            input.input(label='手机号:', type='text', validate=None, name='mobile_phone', value=None,
                                        action=None,
                                        onchange=None,
                                        placeholder='请输入手机号', required=True, readonly=None, datalist=None,
                                        help_text=None),
                            input.input(label='身份证:', type='text', validate=None, name='id_card', value=None,
                                        action=None,
                                        onchange=None,
                                        placeholder='请输入身份证', required=True, readonly=None, datalist=None,
                                        help_text=None)
                            ])
    name = ip['user_name']
    phone = ip['mobile_phone']
    idcard = ip['id_card']

    # 请求接口
    res = req(name, phone, idcard)
    print(res)
    url = res['data']['oss_url']
    order_id = res['data']['mx_order_no']
    message = res['message']

    output.put_image(url)
    output.put_text('订单号:' + order_id, position=-2)
    output.put_text(message, position=-1)


def req(name, phone, idcard):
    url = 'http://project.picahealth.com/create_mx_test_order?name=' + name + '&phone=' + phone + '&id_card=' + idcard
    # print(url)
    res = requests.get(url)  # 使用params参数传递
    # print(res.json())
    res = res.json()
    return res



