from pywebio.input import *
from pywebio.output import *
from pywebio.session import *
from pywebio.pin import *
from pywebio import start_server

# The width ratio of the left and right code blocks is 2:3, which is equivalent to size='2fr 10px 3fr'
from controller.request_method import get_trade_hospital


def main_page():
    put_row(
        [
            # 左边布局
            (put_column(
                # 左上布局
                [
                    # 放置图片
                    put_image(open('/home/pythonWeb/static/image/pyWebIO.png', 'rb').read()),
                    # 左下布局

                    put_scrollable(
                        put_column([
                            put_link('*获取token', '/web/get_token').style(
                                'font-weight:bolder;font-size:18px;font-family:宋体;color:black'),
                            put_link('*获取unionId', '/web/insurance').style(
                                'font-weight:bolder;font-size:18px;font-family:宋体;color:black'),
                            put_link('*获取手机信息(仅线上)', '/web/insurance').style(
                                'font-weight:bolder;font-size:18px;font-family:宋体;color:black'),
                            put_link('*清除小程序授权', '/web/insurance').style(
                                'font-weight:bolder;font-size:18px;font-family:宋体;color:black'),
                            put_link('*保险测试工具', '/web/insurance').style(
                                'font-weight:bolder;font-size:18px;font-family:宋体;color:black'),
                            put_link('*模块化参数创建', '/web/insurance').style(
                                'font-weight:bolder;font-size:18px;font-family:宋体;color:black'),
                            put_link('*人群归属查询', '/web/insurance').style(
                                'font-weight:bolder;font-size:18px;font-family:宋体;color:black'),
                            put_link('*XXLjob执行工具', '/web/insurance').style(
                                'font-weight:bolder;font-size:18px;font-family:宋体;color:black'),
                        ],
                            size='auto auto')
                        , height=600, keep_bottom=True)
                ],
                size='auto auto')),

            None,

            # 右边布局
            put_scrollable((
                put_tabs([
                    {'title': '主要服务机构(前5)', 'content': put_table(get_trade_hospital(), header=["机构类型", "数量"])},
                    {'title': '测试质量', 'content': put_markdown('~~Strikethrough~~')},
                    {'title': '自动化监控', 'content': [
                        put_table([
                            ['Commodity', 'Price'],
                            ['Apple', '5.5'],
                            ['Banana', '7'],
                        ]),
                        put_link('pywebio', 'https://github.com/wang0618/PyWebIO')
                    ]},
                ])), height=705, keep_bottom=True)

        ],
        size='30% 2px 70%')
