/* eslint-disable */
import { envConfig } from '@/utils/env-config';

export function setEventByModuleCode(itemData) {
  const modeCode = itemData.appModuleInfo.code || '';
  let paramList = itemData.appModuleInfo.paramList
    ? itemData.appModuleInfo.paramList
    : '';
  if (modeCode === 'M001' || modeCode === 'M002' || modeCode === 'M003') {
    paramList = '';
  } else if (modeCode === 'M100' || modeCode === 'M300') {
    const urlPara = getUrlParmByCode(paramList);
    paramList[0] && (paramList[0].value += urlPara);
  } else if (modeCode === 'M400') {
  }
  if (typeof paramList === 'string' && !paramList) {
    paramList = [];
  }

  return paramList;
}

function getUrlParmByCode(paramList) {
  if (paramList.length <= 1) {
    return '';
  }
  let dataStr = '';
  const list = [];
  for (let i = 1; i < paramList.length; i++) {
    list.push(paramList[i].key + '=' + paramList[i].value);
  }
  dataStr = list.join('&');
  if (dataStr !== '') {
    return '?' + dataStr;
  }
  return '';
}

export function p_getElm(elmId) {
  return document.getElementById(elmId);
}

export function deepCopy(obj) {
  var result = Array.isArray(obj) ? [] : {};
  for (var key in obj) {
    if (Object.prototype.hasOwnProperty.call(obj, key)) {
      if (typeof obj[key] === 'object') {
        result[key] = deepCopy(obj[key]); // 递归复制
      } else {
        result[key] = obj[key];
      }
    }
  }
  return result;
}

/**
 *
 * @param {Array}     originData  初始数据
 * @param {Boolean}   isUp        true: 升序  false: 降序
 * @param {String}    sortField   排序字段，如果没有，则直接排序
 * @param {Function}  converFun   字段对应的数值转换函数
 */
export function arraySort(originData, isUp = true, sortedField, converFun) {
  // debugger
  const sortedData = originData.slice();
  let swap, sourceA, sourceB;
  for (let i = 0; i < sortedData.length - 1; i++) {
    for (let j = 0; j < sortedData.length - i - 1; j++) {
      sourceA = sortedData[j];
      sourceB = sortedData[j + 1];
      if (sortedField && !converFun) {
        sourceA = sourceA[sortedField];
        sourceB = sourceB[sortedField];
      } else if (sortedField && converFun && typeof converFun === 'function') {
        if (!sourceA[sortedField] || !sourceB[sortedField]) {
          sourceA = 0;
          sourceB = 0;
        } else {
          sourceA = converFun(sourceA[sortedField]);
          sourceB = converFun(sourceB[sortedField]);
        }
      }
      if (isUp) {
        if (sourceA - 0 > sourceB - 0) {
          swap = sortedData[j];
          sortedData[j] = sortedData[j + 1];
          sortedData[j + 1] = swap;
        }
      } else {
        if (sourceA - 0 < sourceB - 0) {
          swap = sortedData[j];
          sortedData[j] = sortedData[j + 1];
          sortedData[j + 1] = swap;
        }
      }
    }
  }
  return sortedData;
}

export function sortParmData(originData, orderCol) {
  return originData.sort((a, b) => {
    return (a[orderCol] - b[orderCol]) * -1;
  });
}

// 获取SC服务器域名地址
export function getBaseUrl(url) {
  return getConfigByEnvType('baseUrl') + url;
}

// 获取七牛token
export function getQiniuToken1() {
  return getConfigByEnvType('qiniuFileUrl');
}

// 登录URL
export function getLoginUrl() {
  return getConfigByEnvType('loginUrl');
}
export function getInnerLoginUrl() {
  return getConfigByEnvType('innerLoginUrl');
}

// 云鹊医首页
export function getYunQueYiUrl() {
  return getConfigByEnvType('yuequeyiIndexUrl');
}

// 七牛上传视频和图片
export function uploadVideo() {
  return getConfigByEnvType('qiniuResourceUrl');
}

export function uploadImg() {
  return getConfigByEnvType('qiniuImgUrl');
}

// 根据不同环境，生成URL
function getConfigByEnvType(urlType) {
  return envConfig[process.env.VUE_APP_ENV][urlType];
}

// 获取客服的云信ID
export function getPicaKFAccid() {
  return getConfigByEnvType('picakfAccId');
}

// 获取客服的云信ID
export function getPhomeDemain() {
  return getConfigByEnvType('phomeDemain');
}

// 根据身份证获取生日
export function getBirth(idCard) {
  let birthday = '';
  if (idCard != null && idCard != '') {
    if (idCard.length == 15) {
      birthday = '19' + idCard.slice(6, 12);
    } else if (idCard.length == 18) {
      birthday = idCard.slice(6, 14);
    }
    birthday = birthday.replace(/(.{4})(.{2})/, '$1-$2-');
    // 通过正则表达式来指定输出格式为:1990-01-01
  }
  return birthday;
}
