import fetch from '../fetch';
import { getBaseUrl } from '@/utils/index'
let headers = {
  'Content-Type': 'application/json;charset=UTF-8',
  token:  localStorage.getItem('storageToken'),
};

/*保存问诊相关信息*/
export const updateDiagnosis = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`/diagnose/admin/diagnose/model/save`),
    method: 'post',
    data: params,
    description: '保存问诊相关信息',
  })
};

/*批量设置运营*/
export const batchSetOperator = (params) => {
  return fetch({
    headers,
    url: getBaseUrl(`/diagnose/admin/diagnose/batch/operator`),
    method: 'post',
    data: params,
    description: '批量设置运营',
  })
};

