import fetch from '@/utils/fetch'
import { getBaseUrl, getApiUrl } from '@/utils/index'

module.exports = {
    data: function () {
        return {
            // isIpx: Utils.env.isIPhoneX(),//是不是iphoneX
            // isAndroid: Utils.env.isAndroid(),
            // isIOS: false,
            // isWeb: false,
            token: null
        }
    },
    created: function () {
        let query = this.$router.query
        // this.token = this.getUrlSearch(location.href, 'token') || (query && query.token) || null
        this.token = this.getUrlKey('token') || (query && query.token) || null
    },
    mounted() {

    },
    methods: {
        getUrlPara(obj) {
            let dataStr = ''
            let list = [];
            for (let attr in obj) {
                if (obj.hasOwnProperty(attr)) {
                    list.push(attr + '=' + obj[attr])
                }
            }
            dataStr = list.join('&')
            if (dataStr !== '') {
                return '?' + dataStr
            }
            return ''
        },

        // 通用GET请求
        GET(api, para, callback) {
            para.token = para.token || this.token || '625D128F3DBA486AABE7CBA9BDF90E69' //'AF3DFCF2DD4B4115AC47ACA25D5420E9''F90DF48D3EFA49DFAE1267A67DBEFB18'//token
            let url = api + this.getUrlPara(para)
            return fetch({
                url: getBaseUrl(url),
                method: 'get',
                data: para
            })
        },

        // 通用POST请求
        POST(api, para, callback) {
            para.token = para.token || this.token || '625D128F3DBA486AABE7CBA9BDF90E69' //'AF3DFCF2DD4B4115AC47ACA25D5420E9''F90DF48D3EFA49DFAE1267A67DBEFB18'//token
            return fetch({
                url: getBaseUrl(api),
                method: 'post',
                data: para
            })
        },
        
        // 通用GET请求
        API_GET(api, para, callback) {
            para.token = para.token || this.token || '625D128F3DBA486AABE7CBA9BDF90E69' //'AF3DFCF2DD4B4115AC47ACA25D5420E9''F90DF48D3EFA49DFAE1267A67DBEFB18'//token
            let url = api + this.getUrlPara(para)
            return fetch({
                url: getApiUrl(url),
                method: 'get',
                data: para
            })
        },

        // 通用POST请求
        API_POST(api, para, callback) {
            para.token = para.token || this.token || '625D128F3DBA486AABE7CBA9BDF90E69' //'AF3DFCF2DD4B4115AC47ACA25D5420E9''F90DF48D3EFA49DFAE1267A67DBEFB18'//token
            return fetch({
                url: getApiUrl(api),
                method: 'post',
                data: para
            })
        },

        // 从html参数
        getUrlKey(name) {
            if (decodeURIComponent && location.href) {
                return decodeURIComponent((new RegExp('[?|&]' + name + '=' + '([^&;]+?)(&|#|;|$)').exec(location.href) || [, ""])[1].replace(/\+/g, '%20')) || null
            } else {
                return null
            }
        },
        getUrlSearch(url, name) {
            if (typeof name == 'undefined') {
                name = url
                url = location.href
            }
            var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)", "i");
            var r = url.slice(url.indexOf('?') + 1).match(reg);
            if (r != null) {
                try {
                    return decodeURIComponent(r[2]);
                } catch (_e) {
                    return null
                }
            }
            return null
        },

    }
}
