class WebIMObj {
  constructor(params) {
    this.accountModel = null;
    this.imListener = null;
    this.boardNotifyCallback = null;
    this.compatSaas = null;
    this.groupChatId = null;
    this.groupBoardId = null;
    this.xmlHttp = null;
    this.tim = null;
    this.callbackobj = null;
    this.roomId = params.roomId
  }

  init(sdkAppId) {
    var options = {
      SDKAppID: sdkAppId // 接入时需要将0替换为您的即时通信 IM 应用的 SDKAppID
    };
    this.tim = window.TIM.create(options);
    this.tim.setLogLevel(0); // 普通级别，日志量较多，接入时建议使用
    this.tim.registerPlugin({
      'cos-js-sdk': window.COS
    }); // 注册 COS SDK 插件
  }

  login(accountModel) {
    this.accountModel = accountModel;
    this.uninitEvent();
    this.initEvent();
    return this.tim.login({
      userID: String(accountModel.userId),
      userSig: String(accountModel.userSig)
    });
  }

  initEvent() {
    this.tim.on(window.TIM.EVENT.MESSAGE_RECEIVED, this.onMessageReceived, this) // SDK 收到推送的单聊、群聊、群提示、群系统通知的新消息
    // this.tim.on(window.TIM.EVENT.GROUP_SYSTEM_NOTICE_RECEIVED, this.onGroupSystemNoticeReceived, this) // SDK 收到新的群系统通知时触发
    this.tim.on(window.TIM.EVENT.KICKED_OUT, this.onKickedOut, this) // 用户被踢下线时触发

  }
  uninitEvent() {
    this.tim.off(window.TIM.EVENT.MESSAGE_RECEIVED, this.onMessageReceived) // SDK 收到推送的单聊、群聊、群提示、群系统通知的新消息
    // this.tim.off(window.TIM.EVENT.GROUP_SYSTEM_NOTICE_RECEIVED, this.onGroupSystemNoticeReceived) // SDK 收到新的群系统通知时触发
    this.tim.off(window.TIM.EVENT.KICKED_OUT, this.onKickedOut) // 用户被踢下线时触发
  }


  logout() {
    this.uninitEvent();
    return this.tim.logout();
  }

  /**
   * 请以一下命名回调方法：
   * 有成员进入onRecvJoinMessage
   * 有成员退出onRecvOutMessage
   * 收到C2C文本消息onRecvTextMessage
   * 收到C2C自定义消息onRecvCustomMessage
   * 收到群文本消息onRecvGroupTextMessage
   * 收到群自定义消息onRecvGroupCustomMessage
   * 所有消息onRecvMessage
   * 被踢出群组onClassroomDestroy
  */
  // 增加回调函数
  addEvent(v) {
    
    this.callbackobj = v
  }
  /**
   * @classId 群组id
   * @scene 场景
   */
  createRoom(groupId) {
    groupId = String(groupId);

    let groupType = null;
    // 创建聊天室
    groupType = window.TIM.TYPES.GRP_AVCHATROOM;
    var options = {
      name: groupId,
      groupID: groupId,
      type: groupType,
      joinOption: window.TIM.TYPES.JOIN_OPTIONS_FREE_ACCESS //自由加入
    };

    return this.tim.createGroup(options).then(() => { // 创建成功
      return Promise.resolve();
    }).catch(function () {
      if (error.code == 10025) { // 群组 ID 已被使用，并且操作者为群主，可以直接使用。
        return Promise.resolve();
      } else {
        // return Promise.reject(error);
        return Promise.resolve();
      }
    });
  }

  /**
   * 加入群
   */
  joinRoom(groupId) {
    groupId = String(groupId);
    return this.tim.joinGroup({
      groupID: groupId,
      type: window.TIM.TYPES.GRP_AVCHATROOM,
    }).then(res => {
      switch (res.data.status) {
        case window.TIM.TYPES.JOIN_STATUS_SUCCESS: // 加群成功
        case window.TIM.TYPES.JOIN_STATUS_ALREADY_IN_GROUP: // 已经在群中
          return Promise.resolve();
        case window.TIM.TYPES.JOIN_STATUS_WAIT_APPROVAL: // 等待管理员同意,业务上认为失败
        default:
          return Promise.reject(res);
      }
    }, error => {
      if (error.code == 10013) { // 被邀请加入的用户已经是群成员,也表示成功
        return Promise.resolve();
      } else if (error.code == -12) { // Join Group succeed; But the type of group is not AVChatRoom
        return Promise.resolve();
      }
      return Promise.reject(error);
    });
  }

  /**
   * 销毁群组
   */
  destroyGroup(groupId) {
    groupId = String(groupId);
    return this.tim.dismissGroup(groupId);
  }

  /**
   * 退出群组
   */
  quitGroup(groupId) {
    let Id = String(groupId);
    return this.tim.quitGroup(Id).then(res => {
      return Promise.resolve();
    }, error => {
      // 群不存在 或者 不在群里了 或者 群id不合法（一般这种情况是课堂销毁了groupId被重置后发生）
      if (error.code === 10010 || error.code === 10007 || error.code === 10015) {
        return Promise.resolve();
      } else if (error.code == 10009) { // 群主自己想退课堂
        return Promise.resolve();
      } else {
        return Promise.reject(error);
      }
    });
  }

  onKickedOut(callback) {
    callback && callback()
  }

  onGroupSystemNoticeReceived(event) {
    const message = event.data.message; // 群系统通知的消息实例，详见 Message
    const payload = message.payload;
    switch (payload.operationType) {
      case 4: // 被踢出群组
        if (event.data.message.to == this.groupChatId) {
          this.callbackobj && this.callbackobj.onClassroomDestroy && this.callbackobj.onClassroomDestroy()
        }
        break;
      case 5: // 群组被解散
        if (event.data.message.to == this.groupChatId) {
          this.callbackobj && this.callbackobj.onClassroomDestroy && this.callbackobj.onClassroomDestroy()
        }
        break;
      case 11: //群已被回收(全员接收)
        if (event.data.message.to == this.groupChatId) {
          this.callbackobj && this.callbackobj.onClassroomDestroy && this.callbackobj.onClassroomDestroy()
        }
        break;
      case 255:
        console.warn('系统消息255：：：', event.data.message)
        break;
    }
  }

  onMessageReceived(event) {
    let messages = event.data;
    this.updateLiveCount();
    messages.forEach((message) => {
      // 群组消息
      if (message.conversationType === window.TIM.TYPES.CONV_GROUP) {
        if (message.to == this.roomId) { // 如果是当前群组
          let elements = message.getElements();
          if (elements.length) {
            elements.forEach((element) => {
              console.log(element.type);

              if (element.type === 'TIMGroupTipElem') {
                switch (element.content.operationType) {
                  // 有成员进入
                  case window.TIM.TYPES.GRP_TIP_MBR_JOIN:
                    this.callbackobj && this.callbackobj.onRecvJoinMessage && this.callbackobj.onRecvJoinMessage(element.content.userIDList, message.nick)
                    console.log('js::::有人进来了');
                    break;
                  // 有成员退出
                  case window.TIM.TYPES.GRP_TIP_MBR_QUIT:
                    console.log('js::::有人退出了');
                    this.callbackobj && this.callbackobj.onRecvOutMessage && this.callbackobj.onRecvOutMessage(element.content.userIDList, message.nick)
                    break;
                }
              } else if (element.type === 'TIMTextElem') {
                // 有群组消息
                console.log('js::::有群组消息');
                this.callbackobj.setMessagesBack(message);
                this.callbackobj && this.callbackobj.onRecvGroupTextMessage && this.callbackobj.onRecvGroupTextMessage(message.from, element.content.text, element.content.text.length, message.nick)
              }  else if (element.type === 'TIMCustomElem') {
                // 有群自定义消息
                 if (element.content.extension === 'TXConferenceExt') {
                  // 对时消息过滤掉
                } else {
                   console.log('js::::有群自定义消');
                   console.log(this.callbackobj);

                   this.callbackobj && this.callbackobj.onRecvGroupCustomMessage && this.callbackobj.onRecvGroupCustomMessage(message.from, element.content.data, element.content.data.length, message.nick)
                }
              }
            });
          }
        } else {
          // 其他群组消息忽略
        }
      } else if (message.conversationType === window.TIM.TYPES.CONV_C2C) { // C2C消息
        let elements = message.getElements();
        if (elements.length) {
          elements.forEach((element) => {
            if (element.type === 'TIMTextElem') {
              // C2C文本消息
              console.log('js:::: C2C文本消息');
              console.log(message)
              this.callbackobj && this.callbackobj.onRecvTextMessage && this.callbackobj.onRecvTextMessage(message.from, element.content.text, element.content.text.length, message.nick)
            } else if (element.type === 'TIMCustomElem') {
              // 自定义消息
              console.log('js:::: C2C自定义消息');
              console.log(message)
              try {
                this.callbackobj && this.callbackobj.onRecvCustomMessage && this.callbackobj.onRecvCustomMessage(message.from, message.payload.data, message.nick)
              } catch (error) {
                console.log('错了：', error)
              }
            }
          });
        }
      }
    });
  }

  updateLiveCount() {
    this.tim.getGroupProfile({ groupID: this.roomId }).then(event => {
      let gl = event.data.group;
      // debugger
      gl.memberNum && this.callbackobj.getImGroupMemberNum(gl.memberNum);
    });
  }


  /**
   * 发送C2C文本消息
   */
  sendC2CTextMessage(userId, msg) {
    let message = this.tim.createTextMessage({
      to: userId,
      conversationType: window.TIM.TYPES.CONV_C2C,
      payload: {
        text: msg
      }
    })
    return this.tim.sendMessage(message).then(() => {
      return Promise.resolve();
    }, (error) => {
      return Promise.reject(error);
    });
  }

  /**
   * 发送C2C自定义消息
   */
  sendC2CCustomMessage(userId, msg) {
    let message = this.tim.createCustomMessage({
      to: userId,
      conversationType: window.TIM.TYPES.CONV_C2C,
      payload: {
        data: msg.data,
        description: msg.description,
        extension: msg.extension
      }
    })
    return this.tim.sendMessage(message).then(() => {
      return Promise.resolve();
    }, (error) => {
      return Promise.reject(error);
    });
  }

  /**
   * 发送群文本消息
   */
  sendGroupTextMessage(msg,id) {
    let toGroupId = id;
    let message = this.tim.createTextMessage({
      to: this.roomId,
      conversationType: window.TIM.TYPES.CONV_GROUP,
      payload: {
        text: msg
      }
    })
    return this.tim.sendMessage(message).then(() => {
      this.callbackobj.setMessagesBack(message);
      return Promise.resolve();
    }, (error) => {
      return Promise.reject(error);
    });
  }

  /**
   * 发送群组自定义消息
   */
  sendGroupCustomMessage(msg, id) {
    let toGroupId = id;
    let message = this.tim.createCustomMessage({
      to: toGroupId,
      conversationType: window.TIM.TYPES.CONV_GROUP,
      payload: {
        data: msg.data,
        description: msg.description,
        extension: msg.extension
      }
    })
    return this.tim.sendMessage(message).then(() => {
      return Promise.resolve();
    }, (error) => {
      return Promise.reject(error);
    });
  }

  getGroup() {
    return this.tim.getGroupProfile({
      groupID: this.roomId}).then((p) => {
        return Promise.resolve(p);
      })
  }

  updateMyProfile(obj) {
    return this.tim.updateMyProfile({
      nick: obj.nick,
      avatar: obj.avatar
    }).then((p) => {
      return Promise.resolve(p);
    }).catch((error) => {
      // 更新资料失败的相关信息
      return Promise.reject(error);
    })
  }

  _getXhr() {
    if (this.xmlHttp) {
      return this.xmlHttp;
    }
    let xmlHttp = null;
    if (window.XMLHttpRequest) {
      xmlHttp = new XMLHttpRequest();
    } else if (window.ActiveXObject) {
      try {
        xmlHttp = new ActiveXObject("Msxml2.XMLHTTP");
      } catch (e) {
        try {
          xmlHttp = new ActiveXObject("Microsoft.XMLHTTP");
        } catch (e) {}
      }
    }
    this.xmlHttp = xmlHttp;
    return xmlHttp;
  }
}

export default WebIMObj;
