import fetch from '../fetch';
import { getBaseUrl } from '@/utils/index';
const headers = {
  'Content-Type': 'application/json;charset=UTF-8',
  token: localStorage.getItem('token'),
};

/* 保存问诊相关信息*/
export const updateDiagnosis = (params) => {
  return fetch({
    headers,
    url: getBaseUrl('/diagnose/admin/diagnose/model/save'),
    method: 'post',
    data: params,
    description: '保存问诊相关信息',
  });
};

/* 保存问诊相关信息*/
export const callAssistantDoctor = (diagnoseLogId) => {
  return fetch({
    headers,
    url: getBaseUrl(`/diagnose/admin/diagnose/callAssistantDoctor/${diagnoseLogId}`),
    method: 'get',
  });
};

export const manualQueue = (params) => {
  return fetch({
    headers,
    url: getBaseUrl('/diagnose/diagnose/manual/queue'),
    method: 'post',
    data: params,
    description: '保存问诊相关信息',
  });
};
/* 批量设置运营*/
export const batchSetOperator = (params) => {
  return fetch({
    headers,
    url: getBaseUrl('/diagnose/admin/diagnose/batch/operator'),
    method: 'post',
    data: params,
    description: '批量设置运营',
  });
};

/* 科室*/
export const getDepList = () => {
  return fetch({
    headers,
    url: getBaseUrl('/hospital/departments/0'),
    method: 'get',
    description: '获得科室',
  });
};
