import request from 'mn-template/plugins/http';
// diagnosis-editor
export const getAdminDiagnose = async (data) => {
  return request({
    url: `/diagnose/admin/diagnose/${data.id}`,
    method: 'get',
  });
};

export const getDoctorList = async (data) => {
  return request({
    url: '/diagnose/doctorService/doctorList',
    params: data,
    method: 'get',
  });
};

export const getDiagnoseLog = async (data) => {
  return request({
    url: `/diagnose/admin/diagnose/log/${data.id}`,
    method: 'get',
  });
};

export const diagnoseUpdate = async (data) => {
  return request({
    url: '/diagnose/admin/diagnose/update',
    data: data,
    method: 'post',
  });
};

// diagnosis-im
export const getQueryTemplate = async () => {
  return request({
    url: '/contents/admin/template/queryTemplate?publishFlag=5&pageNo=1&pageSize=99999',
    method: 'get',
  });
};

export const getMemberList = async (data) => {
  return request({
    url: '/im/team/member/list',
    params: data,
    method: 'get',
  });
};

export const messageForward = async (data) => {
  return request({
    url: '/im/team/message/forward',
    data: data,
    method: 'post',
  });
};

export const messageHistory = async (data) => {
  return request({
    url: '/im/team/message/history',
    data: data,
    method: 'post',
  });
};

export const getOnlineStatus = async (roomId) => {
  return request({
    url: `/coupler/trtc/room/online/userList?roomId=${roomId}`,
    method: 'get',
  });
};

export const messageSend = async (data) => {
  return request({
    url: '/im/team/op/message/send',
    data: data,
    method: 'post',
  });
};

// diagnosis-list-new

export const getCountQuery = async () => {
  return request({
    url: '/diagnose/admin/diagnose/countQuery',
    method: 'get',
  });
};

export const getDepartments = async () => {
  return request({
    url: '/hospital/departments/0',
    method: 'get',
  });
};

export const diagnoseExport = async (data) => {
  return request({
    url: '/diagnose/admin/diagnose/export',
    data: data,
    method: 'post',
  });
};

export const diagnoseList = async (data) => {
  return request({
    url: '/diagnose/admin/diagnose/list',
    data: data,
    method: 'post',
  });
};

export const diagnoseAppointTime = async (data) => {
  return request({
    url: '/diagnose/admin/diagnose/appointTime',
    data: data,
    method: 'post',
  });
};

export const diagnoseEnd = async (data) => {
  return request({
    url: `/diagnose/admin/diagnose/end/${data.diagnoseLogId}`,
    method: 'post',
  });
};

export const diagnoseCall = async (data) => {
  return request({
    url: `/diagnose/admin/diagnose/call/${data.diagnoseLogId}`,
    method: 'post',
  });
};
export const diagnoseChoose = async (data) => {
  return request({
    url: `/diagnose/admin/diagnose/choose/${data.diagnoseLogId}`,
    method: 'post',
  });
};

export const diagnoseCancel = async (data) => {
  return request({
    url: `/diagnose/admin/diagnose/cancel/${data.diagnoseLogId}`,
    method: 'post',
  });
};

// diagnosis-live
export const teamDetail = async (data) => {
  return request({
    url: '/im/team/detail',
    params: data,
    method: 'get',
  });
};

export const getSdkappid = async () => {
  return request({
    url: '/coupler/app/trtc/sdkappid',
    method: 'get',
  });
};

export const streamParams = async () => {
  return request({
    url: '/coupler/app/config/push/stream/params',
    method: 'get',
  });
};

export const callDirect = async (data) => {
  return request({
    url: '/im/team/call/direct/',
    data: data,
    method: 'post',
  });
};
export const manualCall = async (data) => {
  return request({
    url: '/diagnose/admin/diagnose/manual/call',
    data: data,
    method: 'post',
  });
};
// 获取申请取消备注
export const outbounNote = async () => {
  return request({
    url: '/diagnose/admin/diagnose/outbound/note',
    method: 'post',
  });
};
export const usersigTrtc = async (data) => {
  return request({
    url: '/coupler/usersig/trtc',
    data: data,
    method: 'post',
  });
};

export const diagnoseEndCall = async (data) => {
  return request({
    url: `/diagnose/admin/diagnose/endCall/${data.diagnoseLogId}`,
    data: data,
    method: 'post',
  });
};

export const doctorAdviceCreate = async (data) => {
  return request({
    url: '/diagnose/admin/diagnose/doctorAdvice/create',
    data: data,
    method: 'post',
  });
};

export const doctorAdviceList = async (data) => {
  return request({
    url: `/diagnose/admin/diagnose/doctorAdvice/list/${data.diagnoseLogId}`,
    method: 'get',
  });
};

export const operatorQuery = async () => {
  return request({
    url: '/diagnose/admin/diagnose/operator/query',
    method: 'get',
  });
};

export const teamDetailV2 = async (data) => {
  return request({
    url: '/im/team/detail/v2',
    params: data,
    method: 'get',
  });
};

export const stickerSave = async (data) => {
  return request({
    url: '/im/sticker/save',
    post: data,
    method: 'post',
  });
};

export const getStickerList = async () => {
  return request({
    url: '/im/sticker/list',
    method: 'get',
  });
};

export const stickerInfo = async (data) => {
  return request({
    url: '/im/sticker/info',
    params: data,
    method: 'get',
  });
};

export const searchContent = async (data) => {
  return request({
    url: 'contents/searchKeyword/searchContent',
    params: data,
    method: 'get',
  });
};

export const opAck = async (data) => {
  return request({
    url: '/im/team/call/op/ack/',
    data: data,
    method: 'post',
  });
};
export const acceptsCeiling = async (data) => {
  return request({
    url: '/diagnose/admin/diagnose/accepts/ceiling',
    params: data,
    method: 'get',
  });
};

export const getLeisureTime = async (data) => {
  return request({
    url: '/diagnose/doctor/work/getLeisureTime',
    data: data,
    method: 'post',
  });
};

export const outboundIntention = async (data) => {
  return request({
    url: '/diagnose/admin/diagnose/outbound/intention',
    data: data,
    method: 'post',
  });
};

export const departmentAll = async () => {
  return request({
    url: '/diagnose/department/all',
    method: 'get',
  });
};
//
export const updateDepartmentId = async (data) => {
  return request({
    url: '/diagnose/admin/diagnose/diagnoseId/fresh/departmentId',
    data: data,
    method: 'post',
  });
};
