// import "@babel/polyfill";
import Vue from 'vue'
import VueRouter from 'vue-router'
import routes from './router/router'
import store from './store/'
const mixins = require('@/utils/mixins');
import vueFilters from '@/utils/filter'
// import '@/utils/qiniu.min'

// 引入ElementUI
import ElementUI from 'element-ui'
import 'element-ui/lib/theme-chalk/index.css';
import vViewer from 'v-viewer';
import 'viewerjs/dist/viewer.css';
import ClipboardJS from 'clipboard';
// import '@/utils/directive';

Vue.prototype.ClipboardJS = ClipboardJS;
Vue.use(vViewer);

// 可调试
// Vue.config.devtools = true;

Vue.use(ElementUI)

// 注册所有公用过滤器
for(let key in vueFilters) {
	Vue.filter(key, vueFilters[key])
}


Vue.use(VueRouter)
const router = new VueRouter({
	routes,
	mode: 'hash',
	strict: process.env.NODE_ENV !== 'production',
	scrollBehavior (to, from, savedPosition) {
	    if (savedPosition) {
		    return savedPosition
		} else {
			if (from.meta.keepAlive) {
				from.meta.savedPosition = document.body.scrollTop;
			}
		    return { x: 0, y: to.meta.savedPosition || 0 }
		}
	}
})

// 加入混合
Vue.mixin({
	...mixins
})
new Vue({
	router,
	store,
}).$mount('#app')

