import App from '../App'

// 问诊订单管理
const diagnosisList = r => require.ensure([], () => r(require('../views/IM/diagnosis-admin/diagnosis-list.vue')), 'diagnosisList')
const diagnosisIm = r => require.ensure([], () => r(require('../views/IM/diagnosis-admin/diagnosis-im.vue')), 'diagnosisIm')
const diagnosisLive = r => require.ensure([], () => r(require('../views/IM/diagnosis-admin/diagnosis-live.vue')), 'diagnosisLive')
const serviceList = r => require.ensure([], () => r(require('../views/IM/diagnosis-admin/service-list.vue')), 'serviceList')
const assistList = r => require.ensure([], () => r(require('../views/IM/diagnosis-admin/assist-list.vue')), 'assistList')
const diagnosisEditor = r => require.ensure([], () => r(require('../views/IM/diagnosis-admin/diagnosis-editor.vue')), 'diagnosisEditor')
const diagnosisListLod = r => require.ensure([], () => r(require('../views/IM/diagnosis-admin/diagnosis-list-old.vue')), 'diagnosisListLod')

export default [{
    path: '/',
    component: App,
    children: [
        {
            path: '',
            redirect: '/diagnosis-list'
        }, {
            path: '/diagnosis-list',
            component: diagnosisList,
            meta: {
                keepAlive: true // 需要被缓存
            }
        }, {
            path: '/diagnosis-im',
            component: diagnosisIm
        }, {
            path: '/diagnosis-live',
            component: diagnosisLive
        }, {
            path: '/service-List',
            component: serviceList
        },  {
            path: '/assist-list',
            component: assistList
        }, {
            path: '/diagnosis-editor',
            component: diagnosisEditor
        }, {
            path: '/diagnosis-list-old',
            component: diagnosisListLod
        }
    ]
}]
