import { io } from "socket.io-client";

export default {
  namespaced: true,
  state: {
    socketClient: null
  },
  actions: {
    initSocket ({ commit, rootState }, payload) {
      const socket = io("https://example.com", {
        reconnectionDelayMax: 10000,
        reconnectionAttempts:'Infinity',
        reconnection: true,
        transports: ["websocket"], // use WebSocket first, if available
        extraHeaders: {"my-custom-header": "1234"},
        query: {
          x: 42
        }
      });
      commit('SET_SOCKET', socket);
    },
  },
  mutations: {
    SET_SOCKET: (state, payload) => {
      state.socketClient = payload;
    },
    SET_IOLISTION: (state, payload) => {
      if(!state.socketClient){
        return false;
      }
      state.socketClient.on("connection", (socket) => {
        console.log(socket);
      });
      state.socketClient.on("connect_error", (err) => {
        if (err.message === "invalid credentials") {
        }
      });
      state.socketClient.on("disconnect", (socket) => {
        console.log(socket);
      });
      state.socketClient.on("data", (socket) => {
        console.log(socket);
      });
    },
  },
};
