import App from '../App'

const home = r => require.ensure([], () => r(require('../views/home')), 'home')
const blank = r => require.ensure([], () => r(require('../views/blank')), 'blank')
const itemManager = r => require.ensure([], () => r(require('../views/education/item-manager.vue')), 'item-manager')
const itemComponent = r => require.ensure([], () => r(require('../views/education/item-component.vue')), 'item-component')
const createComponent = r => require.ensure([], () => r(require('../views/education/create-component.vue')),'create-component')
const roleManager = r => require.ensure([], () => r(require('../views/system/role.vue')),'role')
const addManager = r => require.ensure([], () => r(require('../views/education/add-manager.vue')), 'add-manager')
const itemRole = r => require.ensure([], () => r(require('../views/system/item-role.vue')), 'item-role')

const createPush = r => require.ensure([], () => r(require('../views/message/create-push.vue')), 'create-push')
const historyPush = r => require.ensure([], () => r(require('../views/message/history-push.vue')), 'history-push')

// 新增 策略管理、短信历史、黑名单、疲劳度控制
const strategyManage = r => require.ensure([], () => r(require('../views/message/strategy-manage.vue')), 'strategy-manage');
const msgHistory = r => require.ensure([], () => r(require('../views/message/msg-history.vue')), 'msg-history');
const blacklist = r => require.ensure([], () => r(require('../views/message/blacklist.vue')), 'blacklist');
const fatigueControl = r => require.ensure([], () => r(require('../views/message/fatigue-control.vue')), 'fatigue-control');

// 新增 协议管理
const protocolList = r => require.ensure([], () => r(require('../views/protocol/protocol-list.vue')), 'protocol-list');
const createProtocol = r => require.ensure([], () => r(require('../views/protocol/create-protocol.vue')), 'create-protocol');
const protocolHistory = r => require.ensure([], () => r(require('../views/protocol/protocol-history.vue')), 'protocol-history');
const protocolDetail = r => require.ensure([], () => r(require('../views/protocol/protocol-detail.vue')), 'protocol-detail');

export default [{
    path: '/',
    component: App,
    children: [
        {
            path: '',
            redirect: '/protocol-list'
        },{
            path: '/index',
            redirect: '/protocol-list'
        },{
            path: '/home',
            redirect: '/protocol-list'
        },{
            path: '/blank',
            component: blank
        },{
            path: '/item-manager',
            component: itemManager
        },{
            path: '/add-manager',
            component: addManager
        },{
            path: '/item-component',
            component: itemComponent
        },{
            path: '/role',
            component: roleManager
        },{
            path: '/create-component',
            component: createComponent
        },{
            path: '/item-role',
            component: itemRole
        },{
            path: '/create-push',
            component: createPush
        },{
            path: '/history-push',
            component: historyPush
        },{
            path: '/strategy-manage',
            component: strategyManage
        },{
            path: '/msg-history',
            component: msgHistory
        },{
            path: '/blacklist',
            component: blacklist
        },{
            path: '/fatigue-control',
            component: fatigueControl
        },{
            path: '/protocol-list',
            component: protocolList
        },{
            path: '/create-protocol',
            component: createProtocol
        },{
            path: '/protocol-detail',
            component: protocolDetail
        },{
            path: '/protocol-history',
            component: protocolHistory
        }
    ]
}]