/**
 *  G-Logger
 *  version 1.0.0
 *  Author: Anndy Yang(Guang Jun)
 *  description: 模拟log4j的日志插件（Vue插件，同时支持浏览器环境）
 * 
 *  log4j提供了4种日志级别和2个日志开关。 
    官方网址: http://logging.apache.org/log4j/1.2/

    DEBUG：输出调试信息；指出细粒度信息事件对调试应用程序是非常有帮助的。 
    INFO： 输出提示信息；消息在粗粒度级别上突出强调应用程序的运行过程。 
    WARN： 输出警告信息；表明会出现潜在错误的情形。 
    ERROR：输出错误信息；指出虽然发生错误事件，但仍然不影响系统的继续运行。 
    FATAL： 输出致命错误；指出每个严重的错误事件将会导致应用程序的退出。 
    ALL level：打开所有日志记录开关；是最低等级的，用于打开所有日志记录。 
    OFF level：关闭所有日志记录开关；是最高等级的，用于关闭所有日志记录。

    按照范围从小到大排序：OFF level > FATAL > ERROR > WARN > INFO > DEBUG > ALL level；范围大的会包含范围小的。
    例如日志设置为INFO级别，则FATAL、ERROR、WARN、INFO的日志开关都是打开的，而DEBUG的日志开关将是关闭的。

    Log4j建议只使用四个级别，优先级从高到低分别是 ERROR、WARN、INFO、DEBUG。
 */

const gLogger = {}
gLogger.install = function (Vue, options) {
  if (gLogger.installed) return
  let logger = {
    isDev: true,
    cLevel: 'debug',
    prefix: 'gLogger Says'
    // levels: ['off', 'fatal', 'error', 'warn', 'info', 'debug', 'all']
  }
  if (options) {
    for (const key of Object.keys(options)) {
        logger[key] = options[key]
    }
  }
  logger.levels = ['off', 'fatal', 'error', 'warn', 'info', 'debug', 'all']
  for (const level of logger.levels) {
    logger[level] = function () {
      if (!this.isDev || typeof console === 'undefined') return
      let levelIndex = logger.levels.indexOf(level)
      // 如果是OFF级别，则不输出日志
      if (levelIndex === 0) return
      let cLevelIndex = logger.levels.indexOf(logger.cLevel)
      // 如果当前级别底，则不输出日志
      if(cLevelIndex < levelIndex) return
      let args = Array.from(arguments)
      args.unshift(`[${this.prefix} :: ${level}]`.toUpperCase())
      console.log(...args)
    }
  }
  Vue.prototype.$log = logger
  if (window) window.logger = logger
}
export default gLogger