export default ($this) => {
  return [


    {
      formType: 'div',
      name: '3.2 心脏病',
      className: 'sec-title',
    },
    {
      formType: 'radio',
      className: 'obj-form-title',
      prop: 'happenedAgain',
      model: 'happenedAgain',
      label: '随访期间是否新发心脏病：',
      disabled: false,
      spanNum: 24,
      options: [
        { label: '无', value: '1', disabled: false },
        { label: '有', value: '2', disabled: false },
      ],
      rules: [{ required: true, message: '请选择是否', trigger: 'change' }],
      changeFun(e){
        if(e == 2) {
          $this.addComponents.forEach((item,index)=>{
            if(item.formName == 'stroke_007'){
              $this.addComponents[index].formObject = {
                ...$this.addComponents[index].formObject,
                type: []
              }
            }
          })
        }
      }
    },
    {
      formType: 'date-picker',
      className: 'obj-form-title2',
      prop: 'firstDiagnoseTime',
      model: 'firstDiagnoseTime',
      placeholder: '请选择',
      label: '首次确诊时间：',
      linkageRule: [{ name: 'happenedAgain', value: ['2'] }],
      format: 'yyyy',
      valueFormat: 'yyyy',
      dateType: 'year',
      type: 'date',
      rules: [{ required: true, message: '首次确诊时间', trigger: 'change' }],
      spanNum: 12,
    },
    {
      formType: 'checkbox',
      className: 'obj-form-title2',
      prop: 'type',
      model: 'type',
      label: '心脏病类型：',
      linkageRule: [{ name: 'happenedAgain', value: ['2'] }],
      disabled: false,
      changeFun: (val)=>{
        // console.log(val)
      },
      spanNum: 24,
      options: [
        { label: '冠心病', value: '1', disabled: false },
        { label: '房颤', value: '2', disabled: false },
        { label: '瓣膜性心脏病', value: '3', disabled: false },
        { label: '具体不详', value: '4', disabled: false },
        { label: '其他', value: '5', disabled: false },
      ],
      rules: [{ required: true, message: '请选择心脏病类型', trigger: 'change' }]
    },
    {
      formType: 'input',
      className: 'obj-form-title4',
      linkageRule: [{name: 'relationshipRemark',value: ['5']}],
      prop: 'remark',
      model: 'remark',
      disabled: false,
      placeholder: '请输入其他心脏病类型',
      spanNum: 12,
      type: 'text',
      labmsg: '',
      rules: [{ required: true, message: '请输入其他心脏病类型', trigger: 'blur' }]
    },
    {
      formType: 'radio',
      className: 'obj-form-title3',
      prop: 'coronaryDiseaseType',
      model: 'coronaryDiseaseType',
      label: '冠心病类型：',
      linkageRule: [{ name: 'type', value: ['1'] }],
      disabled: false,
      spanNum: 24,
      options: [
        { label: '心绞痛', value: '1', disabled: false },
        { label: '心肌梗塞', value: '2', disabled: false },
        { label: '无症状冠脉狭窄', value: '3', disabled: false },
      ],
      rules: [{ required: true, message: '请选择冠心病类型', trigger: 'change' }]
    },
    {
      formType: 'radio',
      className: 'obj-form-title3',
      prop: 'atrialFibrillationType',
      model: 'atrialFibrillationType',
      label: '房颤类型：',
      linkageRule: [{ name: 'type', value: ['2'] }],
      disabled: false,
      spanNum: 24,
      options: [
        { label: '阵发型', value: '1', disabled: false },
        { label: '持续性', value: '2', disabled: false },
        { label: '未知', value: '3', disabled: false },
      ],
      rules: [{ required: true, message: '请选择房颤类型', trigger: 'change' }]
    },
    {
      formType: 'radio',
      className: 'obj-form-title2',
      prop: 'hospitalLevel',
      model: 'hospitalLevel',
      label: '就诊机构级别：',
      linkageRule: [{ name: 'happenedAgain', value: ['2'] }],
      disabled: false,
      spanNum: 24,
      options: [
        { label: '省级医院', value: '1', disabled: false },
        { label: '地级市医院', value: '2', disabled: false },
        { label: '县级医院', value: '3', disabled: false },
        { label: '社区或乡镇卫生机构', value: '4', disabled: false },
      ],
      rules: [{ required: true, message: '请选择评分值', trigger: 'change' }]
    },


    {
      formType: 'radio',
      className: 'obj-form-title',
      prop: 'atrialFibrillation',
      model: 'atrialFibrillation',
      label: '是否有房颤（包括既往及本次随访期间新发现的房颤患者）：',
      disabled: false,
      spanNum: 24,
      options: [
        { label: '无', value: '1', disabled: false },
        { label: '有', value: '2', disabled: false },
      ],
      rules: [{ required: true, message: '请选择是否', trigger: 'change' }],
      changeFun(e){
        if(e == 2) {
          $this.addComponents.forEach((item,index)=>{
            if(item.formName == 'stroke_007'){
              $this.addComponents[index].formObject = {
                ...$this.addComponents[index].formObject,
                drugVariety: []
              }
            }
          })
        }
      }
    },
    {
      formType: 'radio',
      className: 'obj-form-title2',
      prop: 'takeAntithrombotics',
      model: 'takeAntithrombotics',
      label: '是否服用抗栓药物：',
      linkageRule: [{ name: 'atrialFibrillation', value: ['2'] }],
      disabled: false,
      spanNum: 24,
      options: [
        { label: '否', value: '1', disabled: false },
        { label: '是', value: '2', disabled: false },
      ],
      rules: [{ required: true, message: '请选择是否', trigger: 'change' }],

    },
    {
      formType: 'checkbox',
      className: 'obj-form-title2',
      prop: 'drugVariety',
      model: 'drugVariety',
      label: '用药品种：',
      linkageRule: [{ name: 'atrialFibrillation', value: ['2'] }],
      disabled: false,
      changeFun: (val)=>{
        // console.log(val)
      },
      spanNum: 24,
      options: [
        { label: '华法林', value: '1', disabled: false },
        { label: '新型抗凝剂', value: '2', disabled: false },
        { label: '阿司匹林', value: '3', disabled: false },
        { label: '氯吡格雷', value: '4', disabled: false },
        { label: '其他', value: '5', disabled: false },
      ],
      rules: [{ required: true, message: '请选择评分值', trigger: 'change' }]
    },
    {
      formType: 'radio',
      className: 'obj-form-title2',
      prop: 'medicationSituation',
      model: 'medicationSituation',
      label: '用药情况：',
      linkageRule: [{ name: 'atrialFibrillation', value: ['2'] }],
      disabled: false,
      spanNum: 24,
      options: [
        { label: '规律', value: '1', disabled: false },
        { label: '不规律', value: '2', disabled: false },
      ],
      rules: [{ required: true, message: '请选择是否', trigger: 'change' }]
    },




  ]
}
