import fetch from '@/utils/fetch'
import { getBaseUrl, getApiUrl } from '@/utils/index'

module.exports = {
    data: function () {
        return {
            // isIpx: Utils.env.isIPhoneX(),//是不是iphoneX
            // isAndroid: Utils.env.isAndroid(),
            // isIOS: false,
            // isWeb: false,
            token: null
        }
    },
    created: function () {
        let query = this.$router.query
        // this.token = this.getUrlSearch(location.href, 'token') || (query && query.token) || null
        this.token = this.getUrlKey('token') || (query && query.token) || null
    },
    mounted() {

    },
    methods: {
        getUrlPara(obj) {
            let dataStr = ''
            let list = [];
            for (let attr in obj) {
                if (obj.hasOwnProperty(attr) && attr != 'data') {
                    list.push(attr + '=' + obj[attr])
                }
            }
            dataStr = list.join('&')
            if (dataStr !== '') {
                return '?' + dataStr
            }
            return ''
        },
        // pageBurialPoin(options){
            
        //     let opt = {
        //         menuLevel:options.menuLevel || '',
        //         functionCode:options.functionCode || '',
        //         actionCode: options.actionCode || '',
        //        // label:options.label || '',
        //         labelId:options.labelId || '',
        //         labelValue :options.labelValue  || '',
        //         createdTime: options.createdTime || new Date().getTime(),
        //         //type: options.type || '0',
        //         menuCode: options.menuCode || '',
        //       //  menuToCode:options.menuToCode || '',
        //         duration: options.duration || 0,
        //         menuFromCode:options.menuFromCode ||'',
        //         params:options.params || '',
        //         session:options.session || '',
        //     }
        //     console.log(opt);
        //     rocNative.appBuryingPointEntrust(opt)
        // },

        pageBurialPoin(options){
            rocNative.appBuryingPointEntrust(options)
        },

        setRouterParm(paramList){
            let parm = {};
            if(paramList.length<=1){
                return '';
            }
            for(let i=1;i<paramList.length;i++){
                parm[paramList[i].key] = paramList[i].value;
            }
            return parm;
        },

        // 拼接多个参数
        getUrlParmByCode(paramList) {
            if ( paramList.length <= 1) {
                return ''
            }
            let dataStr = ''
            let list = [];
            for( let i = 1; i < paramList.length; i ++) {
                list.push(paramList[i].key + '=' + paramList[i].value)
            }
            dataStr = list.join('&')
            if (dataStr !== '') {
                return '?' + dataStr
            }
            return ''
        },
        //处理五分钟数据 初始化播放状态
        handelFive(d) {
            for (let i = 0; i < d.length; i++) {
                d[i].play = '0';
            }
            return d;
        },

        // 根据条件排序
        async searchForOrder(searchCategory = '1', searchValue = '', sortItem = 1, pageSize = 10, sourceData = []) {
            if(pageSize <=0 ) return;
            let str2 = (searchValue || '').replace(/[\-\_\,\!\|\~\`\(\)\#\$\%\^\&\*\{\}\:\;\"\L\<\>\?]/g, '');// 去掉特殊字符
            let _this = this,
                para = {
                    searchCategory: searchCategory,
                    searchValue: str2,
                    keywordColor: 'rgba(244,122,72,1)',
                    sortItem: sortItem,
                    pageNo: 1,
                    pageSize: pageSize,
                    token: _this.token,
                    setEntry: 'headers',
                }
            let url = 'contents/searchKeyword/searchContent'
      
            let csourceData = await this.GET(url, para).then(res => {
                // _this.searchText = ''
                if (res.code == '000000') {
                    // 课程
                    if(searchCategory.indexOf('1') >= 0) {
                        sourceData = (res.data && res.data.contentAppModels) || []
                    }
                    if(searchCategory.indexOf('2') >= 0) {
                        // sourceData = []
                        sourceData = this.handelFive(res.data.fiveMinutesMedicalContentList || [])
                    }
                    if(searchCategory.indexOf('3') >= 0) {
                        sourceData = (res.data && res.data.pCourseDoctorModels) || []
                    }
                    if(searchCategory.indexOf('4') >= 0) {
                        sourceData = res.data.educationContents
                    }
                }
                return sourceData || []
            })
            return csourceData
        },
      
        setEventByModuleCode(itemData){
           console.log(itemData);
            let modeCode = itemData.appModuleInfo.code || '';
            let paramList = itemData.appModuleInfo.paramList ? itemData.appModuleInfo.paramList : ''

            if( modeCode === 'M001' || modeCode === 'M002' || modeCode === 'M003') {
                paramList = ''
            }else if( modeCode === 'M100' || modeCode === 'M300' ) {
                // 支持多个参数
                let urlPara = this.getUrlParmByCode(paramList);
                if(paramList[0]){
                    if( paramList[0].value.indexOf("?") == -1){
                        paramList[0].value += urlPara
                    }
                }
            } else if (modeCode === 'M400') {
                debugger
                let path = paramList[0]['key'];
                let v = paramList[0]['value'];
                let query = this.setRouterParm(paramList);
                paramList = [{
                    url:v,
                    query:query
                }]
                this.$router.push({
                    path: v,
                    query: query
                })
                //alert(this.token);
               return 'NO'
            }
            if(typeof paramList === 'string' && !paramList){
                paramList = []
            }
            console.log(paramList);
            return paramList;
        },

        // 通用GET请求
        GET(api, para, callback,str) {
            para.token = para.token || this.token || '00175A13D70D4234822D90AC3C74202C'
            let url = api + this.getUrlPara(para)
            return fetch({
                url: getBaseUrl(url),
                method: 'get',
                data: para
            })
        },

        // 通用POST请求
        POST(api, para, callback) {
            para.token = para.token || this.token || '00175A13D70D4234822D90AC3C74202C'
            return fetch({
                url: getBaseUrl(api),
                method: 'post',
                data: para
            })
        },
        
        // 通用GET请求
        API_GET(api, para, callback) {
            para.token = para.token || this.token || '00175A13D70D4234822D90AC3C74202C' //'AF3DFCF2DD4B4115AC47ACA25D5420E9''F90DF48D3EFA49DFAE1267A67DBEFB18'//token
            let url = api + this.getUrlPara(para)
            return fetch({
                url: getApiUrl(url),
                method: 'get',
                data: para
            })
        },

        // 通用POST请求
        API_POST(api, para, callback) {
            para.token = para.token || this.token || '00175A13D70D4234822D90AC3C74202C' //'AF3DFCF2DD4B4115AC47ACA25D5420E9''F90DF48D3EFA49DFAE1267A67DBEFB18'//token
            return fetch({
                url: getApiUrl(api),
                method: 'post',
                data: para
            })
        },

        // 从html参数
        getUrlKey(name) {
            if (decodeURIComponent && location.href) {
                return decodeURIComponent((new RegExp('[?|&]' + name + '=' + '([^&;]+?)(&|#|;|$)').exec(location.href) || [, ""])[1].replace(/\+/g, '%20')) || null
            } else {
                return null
            }
        },
        getUrlSearch(url, name) {
            if (typeof name == 'undefined') {
                name = url
                url = location.href
            }
            var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)", "i");
            var r = url.slice(url.indexOf('?') + 1).match(reg);
            if (r != null) {
                try {
                    return decodeURIComponent(r[2]);
                } catch (_e) {
                    return null
                }
            }
            return null
        },

    }
}
