import followApi from '../../utils/followup/followapis'

export default {
  namespaced: true,
  state: {
    recordList: {}, //录入列表
    enteringInfo: {}, //单条信息查看
    constantsData: {},//获取常量
  },
  mutations: {
    GET_RECORD_LIST(state, payload) {
      state.recordList = payload
    },
    GET_ENTERING_INFO(state, payload) {
      state.enteringInfo = payload
    },
    GET_CONSTANS_DATA(state, payload) {
      state.constantsData = payload
    },
  },
  actions: {
    async getRecordList(context, payload) {
      await followApi.getEnteringList({
        ...payload
      }).then(({data}) => {
        context.commit('GET_RECORD_LIST', data);
      });
    },
    async getEnteringInfo(context, payload) {
      await followApi.getEnteringInfo({}, {
        ...payload
      }).then(({data}) => {
        context.commit('GET_ENTERING_INFO', data);
      });
    },
    // async getConstantsData(context, payload) {
    //   await followApi.getBasicData({
    //     ...payload
    //   }).then(({data}) => {
    //     context.commit('GET_CONSTANS_DATA', data)
    //   })

    // },

  },
}
