const vueFilter = {
  liveDateFilter: (value) => {
      if (!value) return '';
      return new Date(value).format("yyyy-MM-dd hh:mm:ss");
  },
  liveFilter: (value) => {
      if(value.liveStatus == 1){
          return '未开始'
      } else if(value.liveStatus == 5) {
          return '直播中'
      }else if(value.liveStatus == 10 && value.lookBackStatus == 2){
          return '已结束(不可回看)'
      }else if(value.liveStatus == 10 && value.lookBackStatus == 1) {
          return '已结束(可回看)'
      }
  },
  liveStatusFilter: (value) => {
      if(value == 1) return "隐藏"
      else return "发布"    
  },
  liveTeacherType: (value) => {
      let doctorName = []
      if(value.length > 3) {
          for(let i = 0; i < 3; i++) {
              doctorName.push(value[i].doctorName)
          }
          return doctorName.join("、") + '...'
      }else{
          for(let i = 0; i < value.length; i++) {
              doctorName.push(value[i].doctorName)
          }
          return doctorName.join("、")
      }  
  },
  controlType: (value) => {
      if(value == 1) {
          return '分页1'
      }else if(value == 2) {
          return '分页2'
      }else if(value == 3) {
          return '图片1'
      }else if(value == 4) {
          return '图片2'
      }else if(value == 6) {
          return '视频'
      }
  },
  tabControlType: (value) => {
      if(value == 3) {
          return '图片1'
      }else if(value == 4) {
          return '图片2'
      }else if(value == 6) {
          return '视频'
      }
  },
  refreshType: (value) => {
      if(value == 1) return "支持"
      else return "不支持"    
  },
  moudleType: (value) => {
      if(value == 1) return "未激活"
      else return "激活" 
  },
  dateFilter: (value) => {
      if (!value) return '';
      return new Date(value).format("yyyy-MM-dd hh:mm");
  },
  appColumnStatusFilter: (value) => {
      if(value == 1) return "未提交"
      else if(value == 4) return "已提交"  
  },
  statusFilter: (value) => {
      if(value == 1) return "已创建"
      else if(value == 5) return "已发布"
      else return "已下架"    
  },
  linkTypeFilter: (value) => { // 跳转类型
      if(value == 1) return '链接'
      else if(value == 4) return '模块'
      else return '无跳转'
  },
  teacherStatusFilter: (value) => {
      if(value == 1) return "已下架"
      else return "已发布"    
  },
  moduleTypeFilter: (value,data) => {  // 模块类型
      for(let key in data) {
          if(value == key) {
              return data[key]
          }
      }
  },
  contentCreatedType: (value,data) => {
      for(let i = 0; i< data.length;i++) {
          if(value == data[i].id) {
              return data[i].name
          }
      }

  },
  contentModifiedType: (value,data) => {
      for(var i=0; i < data.length;i++) {
          if(value == data[i].id) {
              return data[i].name
          }
      }
  },
  columnPositionType: (value,data) => {  // 位置
      for(let key in data) {
          if(value == key) {
              return data[key]
          }
      }
  },
  // 项目组件
  statusFileter: (value) => {
     if(value == 1) {
         return '草稿'
     }else if(value == 2) {
         return '未启用'
     }else if(value == 3) {
         return '已启用'
     }else {
         return '已禁用'
     }
  },
  //项目管理
  statusProject: (value) => {
    //console.log(value)
    if(value[0] == 1) {
        return '草稿'
    }else if(value[0] == 2) {
        return '未上架'
    }else if(value[0] == 3) {
        if(value[1] == 1) {
            return '待审核'
        } else {
            return '审核中'
        }
    }else if(value[0] == 4) {
        return '已上架'
    }else if(value[0] == 5) {
        return '已下架'
    }else if(value[0] == 6) {
        return '已拒绝'
    }
  },
  projeceRoleType: (value) => {
    if(value == "L1") {
        return '内部管理员'
    }else if(value == "L2") {
        return '项目负责人'
    }else if(value == "L3") {
        return '次级负责人'
    } else if(value == "L0") {
        return '普通用户'
    }
  },
  joinStatus: (value) => {
    if(value == "0") {
        return '未参与'
    }else if(value == "1")  {
        return '参与中'
    }else {
        return '已完成'
    }
  },
  reportStatus: (value) => {
    if(value == 1) {
        return '进行中'
    }else if(value == 2)  {
        return '已结束'
    }
  },
  partJoin: (value) => {
    if(value == 1) {
        return '未参与'
    }else  {
        return '参与'
    }
  },
  partFinish: (value) => {
    if(value == 1) {
        return '未完成'
    }else  {
        return '完成'
    }
  },
  projectStatus: (value) => {
    if(value == 1) {
        return '完成项目'
    }else  {
        return '未完成'
    }
  },
  recordValue: (value) => {
    if(value == 1) {
        return '合格'
    }else if(value == 2)  {
        return '不通过'
    }else if(value == 3)  {
        return '优秀'
    }else if(value == 4)  {
        return '无成绩'
    }
  },
  exportStatus: (value) => {
    if(value == 0) {
        return '数据生成中，请稍后---';
    }else if(value == 1) {
        return '数据生成完成';
    } else {
        return '文件生成失败 请重新操作导出';
    }
  },
}
export default vueFilter