import {getReservationList,
  getCheckReservation,
  getReservationPatients,
  getBasicData} from '../../utils/followup/followapis'

export default {
  namespaced: true,
  state: {
    reservationList: { //居民列表
      pageNum: 1, //当前页码
      pageSize: 10, //每页数据大小
      total: null,  //总数
    },
    checkRevervationData: {},//发送预约校验
    constantsData: {},//获取常量
    getRevervationNum: null, //查看已预约人数
  },
  mutations: {
    GET_RESERVATION_LIST(state, payload) {
      state.reservationList = payload
    },
    GET_CHECK_RESERVATION(state, payload) {
      state.checkRevervationData = payload
    },
    GET_CONSTANS_DATA(state, payload) {
      state.constantsData = payload
    },
    GET_REVERVATION_NUM(state, payload) {
      state.getRevervationNum = payload
    },
  },
  actions: {
    getReservationList(context, payload) {
      const { pageSize, pageNum } = context.state.reservationList;
      getReservationList({
        pageSize,
        pageNum,
        ...payload
      }).then(({data}) => {
        context.commit('GET_RESERVATION_LIST', data);
      });
    },
    async getCheckReservation(context, payload) {
      await getCheckReservation({
        ...payload
      }).then(({data}) => {
        context.commit('GET_CHECK_RESERVATION', data)
      })
    },
    async getConstantsData(context, payload) {
      await getBasicData({
        ...payload
      }).then(({data}) => {
        context.commit('GET_CONSTANS_DATA', data)
      })
    },
    getReservationPatients(context, payload) {
      getReservationPatients({
        ...payload
      }).then(({data}) => {
        context.commit('GET_REVERVATION_NUM', data.number)
      })
    },
    // getConstantsData({commit}) {
    //   return new Promise(async (resolve, reject)=>{
    //     const res = await followApi.getBasicData({
    //       ...payload
    //     });
    //     if (res === null) return;
    //     commit('GET_CONSTANS_DATA', res);
    //     resolve() // 接口请求完成
    //   })
    // }


  },
}
