//求并集
export function getUnion(a, b) {
  if (a.constructor === Array && b.constructor === Array) {
    let set1 = new Set(a);
    let set2 = new Set(b);
    return Array.from(new Set([...set1, ...set2]));
  }
  return null;
}
//求差集
export function getDifference(a, b) {
  if (a.constructor === Array && b.constructor === Array) {
    let set1 = new Set(a);
    let set2 = new Set(b);
    return Array.from(new Set([...set1].filter(x => !set2.has(x))));
  }
  return null;
}
//求交集
export function getIntersect(a, b) {
  if (a.constructor === Array && b.constructor === Array) {
    let set1 = new Set(a);
    let set2 = new Set(b);
    return Array.from(new Set([...set1].filter(x => set2.has(x))));
  }
  return null;
}
//获取id的list
export function getIdList(data) {
  let list = [];
  if(typeof data === 'undefined') {
    return list;
  }
  if (data.constructor === Array) {
    for (let i = 0; i < data.length; i++) {
      list.push(data[i].id);
    }
  }
  return list;
}
//区域
export function getDivision(data) {
  if (data === null || data == 'NaN') {
    let empty = [];
    return empty;
  }
  let list = data.split('|');
  let num = [];
  for (let i = 0; i < list.length; i++) {
    num[i] = parseInt(list[i]);
  }
  //console.log(list);
  return num;
}
export function getLevelList(data) {
  let level = [];
  level[0] = {
    id: '0',
    label: '全部医院等级',
  }
  for (let i = 0; i < data.length; i++) {
    let obj = {
      id: data[i].no,
      label: data[i].value,
    }
    level.push(obj);
  }
  //console.log(level);
  return level;
}
function inTags(id, tags) {
  let flag = false;
  for (let i = 0; i < tags.length; i++) {
    if (tags[i].key == id) {
      flag = true;
    }
  }
  return flag;
}
export function inOrganization(list, id) {
  let flag = false;
  if (list.length == 0) {
    flag = true;
  }
  for (let i = 0; i < list.length; i++) {
    if (list[i].id != id) {
      flag = true;
    }
  }
  return flag;
}
export function initTags(value) {
  let tags = [];
  for (let j = 0; j < value.length; j++) {
    let tagsComponent = {};
    tagsComponent.value = value.value;
    tagsComponent[j].name = this.optionsComponent[j].label;
  }
  return tags;
}
//机构列表
export function getOrganizationList(data) {
  let list = [];
  list[0] = {
    value: '0',
    label: '全部机构',
  };
  for (let i = 0; i < data.length; i++) {
    let obj = {
      value: data[i].key,
      label: data[i].name,
    }
    list.push(obj);
  }
  return list;
}
//机构列表
export function getHospitalList(data) {
  let list = [];
  list[0] = {
    value: 0,
    label: '全部医院',
  };
  for (let i = 0; i < data.length; i++) {
    let obj = {
      value: data[i].id,
      label: data[i].name,
    }
    list.push(obj);
  }
  //console.log(list);
  return list;
}

//拼树
export function changeTags(option) {
  let list = [];
  // for(let i=0;i<option.length;i++) {
  //   console.log(option[i].label);
  //   let obj = {
  //     name: option[i].name,
  //     key: option[i].key,
  //   }
  //   list.push(obj);
  // }
  console.log(option);
  return option;
}
// 递归删除多余的节点
function handlerAction(treeData, selData) {
  treeData.forEach((elem, index) => {
    if (!isValuable(elem.value, selData)) {
      treeData.splice(index, 1)
      handlerAction(treeData, selData)
    } else {
      if (elem.children) {
        handlerAction(elem.children, selData)
      }
    }
  })
  return treeData;
}
function isValuable(val, selData) {
  for (let i = 0; i < selData.length; i++) {
    if (selData[i]['value'].indexOf(val) >= 0) {
      return true
    }
  }
  return false
}
function changeTreeKey(oData, orgKey, targetKey) {
  oData = [...oData]
  oData.forEach(elem => {
    elem[targetKey] = elem[orgKey]
    delete elem[orgKey]
    if (elem.children) {
      changeTreeKey(elem.children, orgKey, targetKey)
    }
  })
  return oData
}
function deleteTreeKey(oData, delKeys) {
  oData = [...oData]
  oData.forEach(elem => {
    delKeys.forEach(key => {
      delete elem[key]
    })
    if (elem.children) {
      deleteTreeKey(elem.children, delKeys)
    }
  })
  return oData
}
function deleteEmptyChild(oData) {
  oData = [...oData]
  oData.forEach(elem => {
    if (elem.children && elem.children.length == 0) {
      delete elem.children
    } else if (elem.children) {
      deleteEmptyChild(elem.children)
    }
  })
  return oData
}
function addEmpty(data) {
  let after = [];
  after[0] = {
    label: "全部地区",
    value: "0",
  }
  for(let i=0;i<data.length;i++) {
    after.push(data[i]);
  }
  return after;
}
export function treeHandler(treeData, selData) {
  //console.log('treeData',treeData,'selData',selData);
  treeData = deleteTreeKey(treeData, ['status', 'disabled'])
  treeData = changeTreeKey(treeData, 'id', 'value')
  selData = changeTreeKey(selData, 'name', 'label')
  selData = changeTreeKey(selData, 'key', 'value')
  let endData = deleteEmptyChild(handlerAction(treeData, selData));
  // console.log(treeData, selData)
  //return handlerAction(treeData, selData);
  let returnData = addEmpty(endData);
  return returnData;
}